/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api;

import io.jafar.parser.ParsingUtils;
import io.jafar.parser.api.ParserContext;
import io.jafar.parser.internal_api.RecordingStreamReader;
import java.io.IOException;
import java.nio.file.Path;

public final class RecordingStream
implements AutoCloseable {
    private final RecordingStreamReader reader;
    private final ParserContext context;
    private long mark = -1L;

    RecordingStream(Path path, ParserContext context) throws IOException {
        this(RecordingStreamReader.mapped(path), context);
    }

    public RecordingStream slice(long pos, long len, ParserContext context) {
        return new RecordingStream(this.reader.slice(pos, len), context);
    }

    public RecordingStream(RecordingStreamReader reader, ParserContext context) {
        this.reader = reader;
        this.context = context;
        this.context.put(RecordingStream.class, this);
    }

    public ParserContext getContext() {
        return this.context;
    }

    public void position(long position) {
        this.reader.position(position);
    }

    public long position() {
        return this.reader.position();
    }

    public void read(byte[] buffer, int offset, int length) {
        if (this.available() < (long)length) {
            throw new RuntimeException("unexpected EOF");
        }
        this.reader.read(buffer, offset, length);
    }

    public byte read() {
        return this.reader.read();
    }

    public short readShort() {
        return this.reader.readShort();
    }

    public int readInt() {
        return this.reader.readInt();
    }

    public long readLong() {
        return this.reader.readLong();
    }

    public float readFloat() {
        return this.reader.readFloat();
    }

    public double readDouble() {
        return this.reader.readDouble();
    }

    public long readVarint() {
        return this.reader.readVarint();
    }

    public boolean readBoolean() {
        return this.reader.readBoolean();
    }

    public String readUTF8() throws IOException {
        return ParsingUtils.readUTF8(this, this.context.getStringTypeId());
    }

    public long available() {
        return this.reader.remaining();
    }

    public void skip(int bytes) {
        this.reader.skip(bytes);
    }

    public void mark() {
        this.mark = this.reader.position();
    }

    public void reset() {
        if (this.mark > -1L) {
            this.position(this.mark);
            this.mark = -1L;
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

