/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api;

import io.jafar.parser.ParsingUtils;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataField;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.List;

public final class TypeSkipper {
    private final int[] instructions;

    public static TypeSkipper createSkipper(MetadataClass clz) {
        IntArrayList instructions = new IntArrayList(20);
        if ("java.lang.String".equals(clz.getName())) {
            instructions.add(5);
            return new TypeSkipper(instructions.toIntArray());
        }
        if (clz.isSimpleType() && clz.getFields().size() == 1) {
            String typeName;
            MetadataField singleField = clz.getFields().get(0);
            MetadataClass fieldType = singleField.getType();
            while (fieldType.isSimpleType() && fieldType.getFields().size() == 1) {
                fieldType = fieldType.getFields().get(0).getType();
            }
            switch (typeName = fieldType.getName()) {
                case "byte": 
                case "boolean": {
                    instructions.add(2);
                    break;
                }
                case "char": 
                case "short": 
                case "int": 
                case "long": {
                    instructions.add(6);
                    break;
                }
                case "float": {
                    instructions.add(3);
                    break;
                }
                case "double": {
                    instructions.add(4);
                    break;
                }
                case "java.lang.String": {
                    instructions.add(5);
                    break;
                }
                default: {
                    for (MetadataField fld : fieldType.getFields()) {
                        TypeSkipper.fillSkipper(fld, (IntList)instructions);
                    }
                }
            }
            return new TypeSkipper(instructions.toIntArray());
        }
        for (MetadataField fld : clz.getFields()) {
            TypeSkipper.fillSkipper(fld, (IntList)instructions);
        }
        return new TypeSkipper(instructions.toIntArray());
    }

    private static void fillSkipper(MetadataField fld, IntList instructions) {
        String name;
        int startingSize = instructions.size();
        int arraySizeIdx = -1;
        MetadataClass fldClz = fld.getType();
        if (fld.getDimension() > 0) {
            instructions.add(1);
            arraySizeIdx = instructions.size();
            instructions.add(0);
        }
        boolean withCp = fld.hasConstantPool();
        while (fldClz.isSimpleType()) {
            List<MetadataField> fl = fldClz.getFields();
            fldClz = fl.get(0).getType();
        }
        switch (name = fldClz.getName()) {
            case "byte": 
            case "boolean": {
                instructions.add(2);
                break;
            }
            case "char": 
            case "short": 
            case "int": 
            case "long": {
                instructions.add(6);
                break;
            }
            case "float": {
                instructions.add(3);
                break;
            }
            case "double": {
                instructions.add(4);
                break;
            }
            case "java.lang.String": {
                if (withCp) {
                    instructions.add(7);
                    break;
                }
                instructions.add(5);
                break;
            }
            default: {
                if (withCp) {
                    instructions.add(7);
                    break;
                }
                for (MetadataField subField : fldClz.getFields()) {
                    TypeSkipper.fillSkipper(subField, instructions);
                }
            }
        }
        if (fld.getDimension() > 0) {
            instructions.set(arraySizeIdx, instructions.size() - startingSize - 2);
        }
    }

    public TypeSkipper(int[] instructions) {
        this.instructions = instructions;
    }

    public void skip(RecordingStream stream) throws IOException {
        this.skip(stream, Listener.NOOP);
    }

    public void skip(RecordingStream stream, Listener listener) throws IOException {
        for (int i = 0; i < this.instructions.length; ++i) {
            long from = stream.position();
            int instruction = this.instructions[i];
            if (instruction == 1) {
                int endIndex = ++i + this.instructions[i++];
                int cnt = (int)stream.readVarint();
                if (cnt == 0) {
                    i = endIndex;
                    continue;
                }
                int savedIndex = i;
                instruction = this.instructions[i];
                int j = 0;
                while (j < cnt) {
                    TypeSkipper.skip(instruction, stream);
                    if (endIndex != i++) continue;
                    i = savedIndex;
                    ++j;
                }
                listener.onSkip(i, from, stream.position());
                i = endIndex;
                continue;
            }
            TypeSkipper.skip(instruction, stream);
            listener.onSkip(i, from, stream.position());
        }
    }

    private static void skip(int instruction, RecordingStream stream) throws IOException {
        switch (instruction) {
            case 6: 
            case 7: {
                stream.readVarint();
                break;
            }
            case 2: {
                stream.skip(1);
                break;
            }
            case 3: {
                stream.skip(4);
                break;
            }
            case 4: {
                stream.skip(8);
                break;
            }
            case 5: {
                ParsingUtils.skipUTF8(stream);
            }
        }
    }

    public static interface Listener {
        public static final Listener NOOP = (idx, from, to) -> {};

        public void onSkip(int var1, long var2, long var4);
    }

    private static final class Instructions {
        public static final int ARRAY = 1;
        public static final int BYTE = 2;
        public static final int FLOAT = 3;
        public static final int DOUBLE = 4;
        public static final int STRING = 5;
        public static final int VARINT = 6;
        public static final int CP_ENTRY = 7;

        private Instructions() {
        }
    }
}

