/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api.metadata;

import io.jafar.parser.ParsingUtils;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.metadata.AbstractMetadataElement;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataElementKind;
import io.jafar.parser.internal_api.metadata.MetadataEvent;
import io.jafar.parser.internal_api.metadata.MetadataVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class MetadataAnnotation
extends AbstractMetadataElement {
    private boolean hasHashCode = false;
    private int hashCode;
    private List<MetadataAnnotation> annotations = null;
    private Long classId = null;
    private String classIdVal = null;
    public String value;

    MetadataAnnotation(RecordingStream stream, MetadataEvent event) throws IOException {
        super(stream, MetadataElementKind.ANNOTATION);
        this.readSubelements(event);
    }

    @Override
    protected void onAttribute(String key, String value) {
        switch (key) {
            case "class": {
                this.classIdVal = value;
                break;
            }
            case "value": {
                this.value = value;
            }
        }
    }

    public MetadataClass getType() {
        return this.metadataLookup.getClass(this.classId);
    }

    public long getClassId() {
        if (this.classId == null) {
            this.classId = ParsingUtils.parseLongSWAR(this.classIdVal);
        }
        return this.classId;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    protected void onSubelement(int count, AbstractMetadataElement element) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<MetadataAnnotation>(count);
        }
        if (element.getKind() != MetadataElementKind.ANNOTATION) {
            throw new IllegalStateException("Unexpected subelement: " + (Object)((Object)element.getKind()));
        }
        this.annotations.add((MetadataAnnotation)element);
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visitAnnotation(this);
        if (this.annotations != null) {
            this.annotations.forEach(a -> a.accept(visitor));
        }
        visitor.visitEnd(this);
    }

    public String toString() {
        return "MetadataAnnotation{type='" + (this.getType() != null ? this.getType().getName() : Long.valueOf(this.getClassId())) + '\'' + ", value='" + this.getValue() + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataAnnotation that = (MetadataAnnotation)o;
        return this.getClassId() == that.getClassId() && Objects.equals(this.annotations, that.annotations) && Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        if (!this.hasHashCode) {
            long mixed = this.getClassId() * -7046029254386353131L + (long)Objects.hashCode(this.annotations) * -4126379630918253789L + (long)Objects.hashCode(this.getValue()) * -2876049455945701127L;
            this.hashCode = Long.hashCode(mixed);
            this.hasHashCode = true;
        }
        return this.hashCode;
    }
}

