/*
 * Decompiled with CFR 0.152.
 */
package io.cloudstate.javasupport;

import akka.Done;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.stream.Materializer;
import com.google.protobuf.Descriptors;
import com.typesafe.config.Config;
import io.cloudstate.javasupport.CloudStateRunner;
import io.cloudstate.javasupport.Service;
import io.cloudstate.javasupport.action.Action;
import io.cloudstate.javasupport.action.ActionHandler;
import io.cloudstate.javasupport.crdt.CrdtEntity;
import io.cloudstate.javasupport.crdt.CrdtEntityFactory;
import io.cloudstate.javasupport.crdt.CrdtEntityOptions;
import io.cloudstate.javasupport.entity.Entity;
import io.cloudstate.javasupport.entity.EntityFactory;
import io.cloudstate.javasupport.entity.EntityOptions;
import io.cloudstate.javasupport.eventsourced.EventSourcedEntity;
import io.cloudstate.javasupport.eventsourced.EventSourcedEntityFactory;
import io.cloudstate.javasupport.eventsourced.EventSourcedEntityOptions;
import io.cloudstate.javasupport.impl.AnySupport;
import io.cloudstate.javasupport.impl.action.ActionService;
import io.cloudstate.javasupport.impl.action.AnnotationBasedActionSupport;
import io.cloudstate.javasupport.impl.crdt.AnnotationBasedCrdtSupport;
import io.cloudstate.javasupport.impl.crdt.CrdtStatefulService;
import io.cloudstate.javasupport.impl.entity.AnnotationBasedEntitySupport;
import io.cloudstate.javasupport.impl.entity.ValueEntityStatefulService;
import io.cloudstate.javasupport.impl.eventsourced.AnnotationBasedEventSourcedSupport;
import io.cloudstate.javasupport.impl.eventsourced.EventSourcedStatefulService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public final class CloudState {
    private final Map<String, Function<ActorSystem, Service>> services = new HashMap<String, Function<ActorSystem, Service>>();
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private String typeUrlPrefix = AnySupport.DefaultTypeUrlPrefix();
    private AnySupport.Prefer prefer = AnySupport.PREFER_JAVA();

    public CloudState withClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public CloudState withTypeUrlPrefix(String string) {
        this.typeUrlPrefix = string;
        return this;
    }

    public CloudState preferJavaProtobufs() {
        this.prefer = AnySupport.PREFER_JAVA();
        return this;
    }

    public CloudState preferScalaProtobufs() {
        this.prefer = AnySupport.PREFER_SCALA();
        return this;
    }

    public CloudState registerEventSourcedEntity(Class<?> clazz, Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.FileDescriptor ... fileDescriptorArray) {
        return this.registerEventSourcedEntity(clazz, serviceDescriptor, EventSourcedEntityOptions.defaults(), fileDescriptorArray);
    }

    public CloudState registerEventSourcedEntity(Class<?> clazz, Descriptors.ServiceDescriptor serviceDescriptor, EventSourcedEntityOptions eventSourcedEntityOptions, Descriptors.FileDescriptor ... fileDescriptorArray) {
        int n;
        String string;
        EventSourcedEntity eventSourcedEntity = clazz.getAnnotation(EventSourcedEntity.class);
        if (eventSourcedEntity == null) {
            throw new IllegalArgumentException(clazz + " does not declare an " + EventSourcedEntity.class + " annotation!");
        }
        if (eventSourcedEntity.persistenceId().isEmpty()) {
            string = clazz.getSimpleName();
            n = 0;
        } else {
            string = eventSourcedEntity.persistenceId();
            n = eventSourcedEntity.snapshotEvery();
        }
        AnySupport anySupport = this.newAnySupport(fileDescriptorArray);
        EventSourcedStatefulService eventSourcedStatefulService = new EventSourcedStatefulService((EventSourcedEntityFactory)new AnnotationBasedEventSourcedSupport(clazz, anySupport, serviceDescriptor), serviceDescriptor, anySupport, string, n, eventSourcedEntityOptions);
        this.services.put(serviceDescriptor.getFullName(), actorSystem -> eventSourcedStatefulService);
        return this;
    }

    public CloudState registerEventSourcedEntity(EventSourcedEntityFactory eventSourcedEntityFactory, Descriptors.ServiceDescriptor serviceDescriptor, String string, int n, EventSourcedEntityOptions eventSourcedEntityOptions, Descriptors.FileDescriptor ... fileDescriptorArray) {
        this.services.put(serviceDescriptor.getFullName(), actorSystem -> new EventSourcedStatefulService(eventSourcedEntityFactory, serviceDescriptor, this.newAnySupport(fileDescriptorArray), string, n, eventSourcedEntityOptions));
        return this;
    }

    public CloudState registerCrdtEntity(Class<?> clazz, Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.FileDescriptor ... fileDescriptorArray) {
        return this.registerCrdtEntity(clazz, serviceDescriptor, CrdtEntityOptions.defaults(), fileDescriptorArray);
    }

    public CloudState registerCrdtEntity(Class<?> clazz, Descriptors.ServiceDescriptor serviceDescriptor, CrdtEntityOptions crdtEntityOptions, Descriptors.FileDescriptor ... fileDescriptorArray) {
        CrdtEntity crdtEntity = clazz.getAnnotation(CrdtEntity.class);
        if (crdtEntity == null) {
            throw new IllegalArgumentException(clazz + " does not declare an " + CrdtEntity.class + " annotation!");
        }
        AnySupport anySupport = this.newAnySupport(fileDescriptorArray);
        CrdtStatefulService crdtStatefulService = new CrdtStatefulService((CrdtEntityFactory)new AnnotationBasedCrdtSupport(clazz, anySupport, serviceDescriptor), serviceDescriptor, anySupport, crdtEntityOptions);
        this.services.put(serviceDescriptor.getFullName(), actorSystem -> crdtStatefulService);
        return this;
    }

    public CloudState registerCrdtEntity(CrdtEntityFactory crdtEntityFactory, Descriptors.ServiceDescriptor serviceDescriptor, CrdtEntityOptions crdtEntityOptions, Descriptors.FileDescriptor ... fileDescriptorArray) {
        this.services.put(serviceDescriptor.getFullName(), actorSystem -> new CrdtStatefulService(crdtEntityFactory, serviceDescriptor, this.newAnySupport(fileDescriptorArray), crdtEntityOptions));
        return this;
    }

    public CloudState registerAction(Object object, Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.FileDescriptor ... fileDescriptorArray) {
        Action action = object.getClass().getAnnotation(Action.class);
        if (action == null) {
            throw new IllegalArgumentException(object.getClass() + " does not declare an " + Action.class + " annotation!");
        }
        AnySupport anySupport = this.newAnySupport(fileDescriptorArray);
        this.services.put(serviceDescriptor.getFullName(), actorSystem -> new ActionService(new AnnotationBasedActionSupport(object, anySupport, serviceDescriptor, Materializer.createMaterializer((ClassicActorSystemProvider)actorSystem)), serviceDescriptor, anySupport));
        return this;
    }

    public CloudState registerAction(ActionHandler actionHandler, Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.FileDescriptor ... fileDescriptorArray) {
        AnySupport anySupport = this.newAnySupport(fileDescriptorArray);
        ActionService actionService = new ActionService(actionHandler, serviceDescriptor, anySupport);
        this.services.put(serviceDescriptor.getFullName(), actorSystem -> actionService);
        return this;
    }

    public CloudState registerEntity(Class<?> clazz, Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.FileDescriptor ... fileDescriptorArray) {
        return this.registerEntity(clazz, serviceDescriptor, EntityOptions.defaults(), fileDescriptorArray);
    }

    public CloudState registerEntity(Class<?> clazz, Descriptors.ServiceDescriptor serviceDescriptor, EntityOptions entityOptions, Descriptors.FileDescriptor ... fileDescriptorArray) {
        Entity entity = clazz.getAnnotation(Entity.class);
        if (entity == null) {
            throw new IllegalArgumentException(clazz + " does not declare an " + Entity.class + " annotation!");
        }
        String string = entity.persistenceId().isEmpty() ? clazz.getSimpleName() : entity.persistenceId();
        AnySupport anySupport = this.newAnySupport(fileDescriptorArray);
        ValueEntityStatefulService valueEntityStatefulService = new ValueEntityStatefulService((EntityFactory)new AnnotationBasedEntitySupport(clazz, anySupport, serviceDescriptor), serviceDescriptor, anySupport, string, entityOptions);
        this.services.put(serviceDescriptor.getFullName(), actorSystem -> valueEntityStatefulService);
        return this;
    }

    public CloudState registerEntity(EntityFactory entityFactory, Descriptors.ServiceDescriptor serviceDescriptor, String string, EntityOptions entityOptions, Descriptors.FileDescriptor ... fileDescriptorArray) {
        this.services.put(serviceDescriptor.getFullName(), actorSystem -> new ValueEntityStatefulService(entityFactory, serviceDescriptor, this.newAnySupport(fileDescriptorArray), string, entityOptions));
        return this;
    }

    public CompletionStage<Done> start() {
        return this.createRunner().run();
    }

    public CompletionStage<Done> start(Config config) {
        return this.createRunner(config).run();
    }

    public CloudStateRunner createRunner() {
        return new CloudStateRunner(this.services);
    }

    public CloudStateRunner createRunner(Config config) {
        return new CloudStateRunner(this.services, config);
    }

    private AnySupport newAnySupport(Descriptors.FileDescriptor[] fileDescriptorArray) {
        return new AnySupport(fileDescriptorArray, this.classLoader, this.typeUrlPrefix, this.prefer);
    }
}

