/*
 * Decompiled with CFR 0.152.
 */
package io.cloudstate.javasupport.impl;

import akka.actor.ActorSystem;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.empty.Empty;
import com.google.protobuf.empty.Empty$;
import io.cloudstate.javasupport.BuildInfo$;
import io.cloudstate.javasupport.EntityOptions;
import io.cloudstate.javasupport.PassivationStrategy;
import io.cloudstate.javasupport.Service;
import io.cloudstate.javasupport.impl.AnySupport$;
import io.cloudstate.javasupport.impl.Timeout;
import io.cloudstate.protocol.entity.Entity;
import io.cloudstate.protocol.entity.Entity$;
import io.cloudstate.protocol.entity.EntityDiscovery;
import io.cloudstate.protocol.entity.EntityPassivationStrategy;
import io.cloudstate.protocol.entity.EntityPassivationStrategy$;
import io.cloudstate.protocol.entity.EntitySpec;
import io.cloudstate.protocol.entity.EntitySpec$;
import io.cloudstate.protocol.entity.ProxyInfo;
import io.cloudstate.protocol.entity.ServiceInfo;
import io.cloudstate.protocol.entity.ServiceInfo$;
import io.cloudstate.protocol.entity.TimeoutPassivationStrategy;
import io.cloudstate.protocol.entity.TimeoutPassivationStrategy$;
import io.cloudstate.protocol.entity.UserFunctionError;
import java.io.Serializable;
import java.time.Duration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scalapb.UnknownFieldSet;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001\u0002\u0007\u000e\u0001YA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)\u0011\t\u0001C\u0001\u0005\")q\t\u0001C\u0005\u0011\")Q\n\u0001C\u0005\u001d\"9A\u000b\u0001b\u0001\n\u0013)\u0006BB-\u0001A\u0003%a\u000bC\u0003[\u0001\u0011\u00053\fC\u0003k\u0001\u0011\u00053\u000eC\u0003~\u0001\u0011%a\u0010C\u0004\u0002\u0018\u0001!I!!\u0007\u0003'\u0015sG/\u001b;z\t&\u001c8m\u001c<fefLU\u000e\u001d7\u000b\u00059y\u0011\u0001B5na2T!\u0001E\t\u0002\u0017)\fg/Y:vaB|'\u000f\u001e\u0006\u0003%M\t!b\u00197pk\u0012\u001cH/\u0019;f\u0015\u0005!\u0012AA5p\u0007\u0001\u00192\u0001A\f\u001e!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fMB\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0007K:$\u0018\u000e^=\u000b\u0005\t\n\u0012\u0001\u00039s_R|7m\u001c7\n\u0005\u0011z\"aD#oi&$\u0018\u0010R5tG>4XM]=\u0002\rML8\u000f^3n!\t9C&D\u0001)\u0015\tI#&A\u0003bGR|'OC\u0001,\u0003\u0011\t7n[1\n\u00055B#aC!di>\u00148+_:uK6\f\u0001b]3sm&\u001cWm\u001d\t\u0005a]RTH\u0004\u00022kA\u0011!'G\u0007\u0002g)\u0011A'F\u0001\u0007yI|w\u000e\u001e \n\u0005YJ\u0012A\u0002)sK\u0012,g-\u0003\u00029s\t\u0019Q*\u00199\u000b\u0005YJ\u0002C\u0001\u0019<\u0013\ta\u0014H\u0001\u0004TiJLgn\u001a\t\u0003}}j\u0011aD\u0005\u0003\u0001>\u0011qaU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0004\u0007\u00163\u0005C\u0001#\u0001\u001b\u0005i\u0001\"B\u0013\u0004\u0001\u00041\u0003\"\u0002\u0018\u0004\u0001\u0004y\u0013\u0001E2p]\u001aLw-\u001e:fI>\u0013X\t\\:f)\rQ\u0014j\u0013\u0005\u0006\u0015\u0012\u0001\rAO\u0001\u0004W\u0016L\b\"\u0002'\u0005\u0001\u0004Q\u0014a\u00023fM\u0006,H\u000e^\u0001\u0014G>tg-[4ve\u0016$\u0017J\u001c;Pe\u0016c7/\u001a\u000b\u0004\u001fJ\u001b\u0006C\u0001\rQ\u0013\t\t\u0016DA\u0002J]RDQAS\u0003A\u0002iBQ\u0001T\u0003A\u0002=\u000b1b]3sm&\u001cW-\u00138g_V\ta\u000b\u0005\u0002\u001f/&\u0011\u0001l\b\u0002\f'\u0016\u0014h/[2f\u0013:4w.\u0001\u0007tKJ4\u0018nY3J]\u001a|\u0007%\u0001\u0005eSN\u001cwN^3s)\taV\rE\u0002^A\nl\u0011A\u0018\u0006\u0003?f\t!bY8oGV\u0014(/\u001a8u\u0013\t\tgL\u0001\u0004GkR,(/\u001a\t\u0003=\rL!\u0001Z\u0010\u0003\u0015\u0015sG/\u001b;z'B,7\rC\u0003g\u0011\u0001\u0007q-\u0001\u0002j]B\u0011a\u0004[\u0005\u0003S~\u0011\u0011\u0002\u0015:pqfLeNZ8\u0002\u0017I,\u0007o\u001c:u\u000bJ\u0014xN\u001d\u000b\u0003Yf\u00042!\u00181n!\tqw/D\u0001p\u0015\t\u0001\u0018/A\u0003f[B$\u0018P\u0003\u0002sg\u0006A\u0001O]8u_\n,hM\u0003\u0002uk\u00061qm\\8hY\u0016T\u0011A^\u0001\u0004G>l\u0017B\u0001=p\u0005\u0015)U\u000e\u001d;z\u0011\u00151\u0017\u00021\u0001{!\tq20\u0003\u0002}?\t\tRk]3s\rVt7\r^5p]\u0016\u0013(o\u001c:\u00023\u0015tG/\u001b;z!\u0006\u001c8/\u001b<bi&|gn\u0015;sCR,w-\u001f\u000b\u0004\u007f\u0006-\u0001#\u0002\r\u0002\u0002\u0005\u0015\u0011bAA\u00023\t1q\n\u001d;j_:\u00042AHA\u0004\u0013\r\tIa\b\u0002\u001a\u000b:$\u0018\u000e^=QCN\u001c\u0018N^1uS>t7\u000b\u001e:bi\u0016<\u0017\u0010C\u0004\u0002\u000e)\u0001\r!a\u0004\u0002\u00195\f\u0017PY3PaRLwN\\:\u0011\u000ba\t\t!!\u0005\u0011\u0007y\n\u0019\"C\u0002\u0002\u0016=\u0011Q\"\u00128uSRLx\n\u001d;j_:\u001c\u0018\u0001H2p]\u001aLw-\u001e:fIB\u000b7o]5wCRLwN\u001c+j[\u0016|W\u000f\u001e\u000b\u0005\u00037\ti\u0003E\u0003\u0019\u0003\u0003\ti\u0002\u0005\u0003\u0002 \u0005%RBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\tQLW.\u001a\u0006\u0003\u0003O\tAA[1wC&!\u00111FA\u0011\u0005!!UO]1uS>t\u0007\"\u0002&\f\u0001\u0004Q\u0004")
public class EntityDiscoveryImpl
implements EntityDiscovery {
    private final ActorSystem system;
    private final Map<String, Service> services;
    private final ServiceInfo serviceInfo;

    private String configuredOrElse(String key, String string) {
        return this.system.settings().config().hasPath(key) ? this.system.settings().config().getString(key) : string;
    }

    private int configuredIntOrElse(String key, int n) {
        return this.system.settings().config().hasPath(key) ? this.system.settings().config().getInt(key) : n;
    }

    private ServiceInfo serviceInfo() {
        return this.serviceInfo;
    }

    @Override
    public Future<EntitySpec> discover(ProxyInfo in) {
        this.system.log().info(new StringBuilder(65).append("Received discovery call from [").append(in.proxyName()).append(" ").append(in.proxyVersion()).append("] supporting Cloudstate protocol ").append(in.protocolMajorVersion()).append(".").append(in.protocolMinorVersion()).toString());
        this.system.log().debug(new StringBuilder(32).append("Supported sidecar entity types: ").append(in.supportedEntityTypes().mkString("[", ",", "]")).toString());
        Iterable unsupportedServices = (Iterable)this.services.values().filterNot((Function1 & Serializable)service -> BoxesRunTime.boxToBoolean((boolean)EntityDiscoveryImpl.$anonfun$discover$1(in, service)));
        if (unsupportedServices.nonEmpty()) {
            this.system.log().error(new StringBuilder(67).append("Proxy doesn't support the entity types for the following services: ").append(((IterableOnceOps)unsupportedServices.map((Function1 & Serializable)s -> new StringBuilder(2).append(s.descriptor().getFullName()).append(": ").append(s.entityType()).toString())).mkString(", ")).toString());
        }
        Map<String, Descriptors.FileDescriptor> allDescriptors = AnySupport$.MODULE$.flattenDescriptors((Seq<Descriptors.FileDescriptor>)((IterableOnceOps)this.services.values().map((Function1 & Serializable)x$1 -> x$1.descriptor().getFile())).toSeq());
        DescriptorProtos.FileDescriptorSet.Builder builder = DescriptorProtos.FileDescriptorSet.newBuilder();
        allDescriptors.values().foreach((Function1 & Serializable)fd -> builder.addFile(fd.toProto()));
        ByteString fileDescriptorSet = builder.build().toByteString();
        Seq entities = ((IterableOnceOps)this.services.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Service service = (Service)tuple2._2();
            Option<EntityPassivationStrategy> passivationStrategy = this.entityPassivationStrategy(service.entityOptions());
            Entity entity = new Entity(service.entityType(), name, service.persistenceId(), passivationStrategy, Entity$.MODULE$.apply$default$5());
            return entity;
        })).toSeq();
        return Future$.MODULE$.successful((Object)new EntitySpec(fileDescriptorSet, (Seq<Entity>)entities, (Option<ServiceInfo>)new Some((Object)this.serviceInfo()), EntitySpec$.MODULE$.apply$default$4()));
    }

    @Override
    public Future<Empty> reportError(UserFunctionError in) {
        this.system.log().error(new StringBuilder(29).append("Error reported from sidecar: ").append(in.message()).toString());
        return Future$.MODULE$.successful((Object)Empty$.MODULE$.defaultInstance());
    }

    private Option<EntityPassivationStrategy> entityPassivationStrategy(Option<EntityOptions> maybeOptions) {
        return maybeOptions.flatMap((Function1 & Serializable)options -> {
            Option option;
            PassivationStrategy passivationStrategy = options.passivationStrategy();
            if (passivationStrategy instanceof Timeout) {
                Timeout timeout2 = (Timeout)passivationStrategy;
                Option<Duration> maybeTimeout = timeout2.duration();
                Option<Duration> option2 = maybeTimeout;
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    Duration timeout3 = (Duration)some.value();
                    option = new Some((Object)new EntityPassivationStrategy(new EntityPassivationStrategy.Strategy.Timeout(new TimeoutPassivationStrategy(timeout3.toMillis(), TimeoutPassivationStrategy$.MODULE$.apply$default$2())), EntityPassivationStrategy$.MODULE$.apply$default$2()));
                } else {
                    option = this.configuredPassivationTimeout("cloudstate.passivation-timeout").map((Function1 & Serializable)timeout -> new EntityPassivationStrategy(new EntityPassivationStrategy.Strategy.Timeout(new TimeoutPassivationStrategy(timeout.toMillis(), TimeoutPassivationStrategy$.MODULE$.apply$default$2())), EntityPassivationStrategy$.MODULE$.apply$default$2()));
                }
            } else {
                throw new MatchError((Object)passivationStrategy);
            }
            Option option3 = option;
            return option3;
        });
    }

    private Option<Duration> configuredPassivationTimeout(String key) {
        return this.system.settings().config().hasPath(key) ? new Some((Object)this.system.settings().config().getDuration(key)) : None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$discover$1(ProxyInfo in$1, Service service) {
        return in$1.supportedEntityTypes().contains((Object)service.entityType());
    }

    public EntityDiscoveryImpl(ActorSystem system, Map<String, Service> services) {
        this.system = system;
        this.services = services;
        String x$1 = new StringBuilder(1).append((String)package$.MODULE$.props().getOrElse((Object)"java.runtime.name", (Function0 & Serializable)() -> "")).append(" ").append(package$.MODULE$.props().getOrElse((Object)"java.runtime.version", (Function0 & Serializable)() -> "")).toString();
        String x$2 = this.configuredOrElse("cloudstate.library.name", BuildInfo$.MODULE$.name());
        String x$3 = this.configuredOrElse("cloudstate.library.version", BuildInfo$.MODULE$.version());
        int x$4 = this.configuredIntOrElse("cloudstate.library.protocol-major-version", BuildInfo$.MODULE$.protocolMajorVersion());
        int x$5 = this.configuredIntOrElse("cloudstate.library.protocol-minor-version", BuildInfo$.MODULE$.protocolMinorVersion());
        String x$6 = ServiceInfo$.MODULE$.apply$default$1();
        String x$7 = ServiceInfo$.MODULE$.apply$default$2();
        UnknownFieldSet x$8 = ServiceInfo$.MODULE$.apply$default$8();
        this.serviceInfo = new ServiceInfo(x$6, x$7, x$1, x$2, x$3, x$4, x$5, x$8);
    }
}

