/*
 * Decompiled with CFR 0.152.
 */
package io.clue2solve.pinecone.javaclient.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;

public class FetchRequest {
    private String indexName;
    private String nameSpace;
    private String[] ids;

    public String toString() throws RuntimeException {
        ObjectMapper objectMapper = new ObjectMapper();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("indexName", this.getIndexName());
        map.put("namespace", this.getNameSpace());
        map.put("ids", this.getIds());
        try {
            try {
                return objectMapper.writeValueAsString(map);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getIDsAsString() {
        StringBuilder idsString = new StringBuilder();
        for (String id : this.ids) {
            idsString.append(id).append(",");
        }
        return idsString.substring(0, idsString.length() - 1);
    }

    public static FetchRequestBuilder builder() {
        return new FetchRequestBuilder();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String[] getIds() {
        return this.ids;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public FetchRequest() {
    }

    public FetchRequest(String indexName, String nameSpace, String[] ids) {
        this.indexName = indexName;
        this.nameSpace = nameSpace;
        this.ids = ids;
    }

    public static class FetchRequestBuilder {
        private String indexName;
        private String nameSpace;
        private String[] ids;

        FetchRequestBuilder() {
        }

        public FetchRequestBuilder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public FetchRequestBuilder nameSpace(String nameSpace) {
            this.nameSpace = nameSpace;
            return this;
        }

        public FetchRequestBuilder ids(String[] ids) {
            this.ids = ids;
            return this;
        }

        public FetchRequest build() {
            return new FetchRequest(this.indexName, this.nameSpace, this.ids);
        }

        public String toString() {
            return "FetchRequest.FetchRequestBuilder(indexName=" + this.indexName + ", nameSpace=" + this.nameSpace + ", ids=" + Arrays.deepToString(this.ids) + ")";
        }
    }
}

