/*
 * Decompiled with CFR 0.152.
 */
package io.clue2solve.pinecone.javaclient.model;

import io.clue2solve.pinecone.javaclient.model.UpsertVector;
import java.util.List;
import org.json.JSONObject;

public class UpsertRequest {
    private String indexName;
    private String namespace;
    private List<UpsertVector> upsertVectorsList;

    public JSONObject getRequestAsJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("indexName", (Object)this.getIndexName());
        jsonObject.put("nameSpace", (Object)this.getNamespace());
        jsonObject.put("vectors", this.getUpsertVectorsList());
        return jsonObject;
    }

    public String toString() {
        JSONObject vectorsJson = new JSONObject();
        vectorsJson.put("indexName", (Object)this.getIndexName());
        vectorsJson.put("namespace", (Object)this.getNamespace());
        for (UpsertVector upsertVector : this.upsertVectorsList) {
            JSONObject vectorJson = new JSONObject();
            vectorJson.put("id", (Object)upsertVector.getId());
            vectorJson.put("values", upsertVector.getValues());
            vectorJson.put("metadata", (Object)new JSONObject(upsertVector.getMetadata()));
            vectorsJson.append("vectors", (Object)vectorJson);
        }
        return vectorsJson.toString();
    }

    public static UpsertRequestBuilder builder() {
        return new UpsertRequestBuilder();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public List<UpsertVector> getUpsertVectorsList() {
        return this.upsertVectorsList;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUpsertVectorsList(List<UpsertVector> upsertVectorsList) {
        this.upsertVectorsList = upsertVectorsList;
    }

    public UpsertRequest() {
    }

    public UpsertRequest(String indexName, String namespace, List<UpsertVector> upsertVectorsList) {
        this.indexName = indexName;
        this.namespace = namespace;
        this.upsertVectorsList = upsertVectorsList;
    }

    public static class UpsertRequestBuilder {
        private String indexName;
        private String namespace;
        private List<UpsertVector> upsertVectorsList;

        UpsertRequestBuilder() {
        }

        public UpsertRequestBuilder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public UpsertRequestBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpsertRequestBuilder upsertVectorsList(List<UpsertVector> upsertVectorsList) {
            this.upsertVectorsList = upsertVectorsList;
            return this;
        }

        public UpsertRequest build() {
            return new UpsertRequest(this.indexName, this.namespace, this.upsertVectorsList);
        }

        public String toString() {
            return "UpsertRequest.UpsertRequestBuilder(indexName=" + this.indexName + ", namespace=" + this.namespace + ", upsertVectorsList=" + String.valueOf(this.upsertVectorsList) + ")";
        }
    }
}

