/*
 * Decompiled with CFR 0.152.
 */
package io.clue2solve.pinecone.javaclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.clue2solve.pinecone.javaclient.model.DeleteRequest;
import io.clue2solve.pinecone.javaclient.model.FetchRequest;
import io.clue2solve.pinecone.javaclient.model.FetchResponse;
import io.clue2solve.pinecone.javaclient.model.QueryRequest;
import io.clue2solve.pinecone.javaclient.model.QueryResponse;
import io.clue2solve.pinecone.javaclient.model.UpsertRequest;
import io.clue2solve.pinecone.javaclient.utils.OkHttpClientWrapper;
import io.clue2solve.pinecone.javaclient.utils.OkHttpLoggingInterceptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PineconeDBClient {
    private static final Logger LOG = LoggerFactory.getLogger(PineconeDBClient.class);
    private OkHttpClientWrapper client;
    private final String environment;
    private final String projectId;
    private final String apiKey;

    public PineconeDBClient(String environment, String projectId, String apiKey) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new OkHttpLoggingInterceptor()).build();
        this.client = new OkHttpClientWrapper(okHttpClient);
        this.environment = environment;
        this.projectId = projectId;
        this.apiKey = apiKey;
    }

    public void setClient(OkHttpClientWrapper client) {
        this.client = client;
    }

    public Response describeIndexStats(String indexName) throws IOException {
        String url = this.buildUrl(indexName, EndPoints.DESCRIBE_INDEX_STATS.toString());
        Request request = this.prepareRequestWithNoBody(indexName, url);
        try {
            return this.client.newCall(request).execute();
        }
        catch (IOException e) {
            LOG.error("Error fetching index stats for index: {}", (Object)indexName, (Object)e);
            throw e;
        }
    }

    public List<QueryResponse> query(QueryRequest queryRequest) throws IOException {
        String url = this.buildUrl(queryRequest.getIndexName(), EndPoints.QUERY.toString());
        Request request = this.prepareQueryRequest(queryRequest, url);
        List<QueryResponse> queryResponses = null;
        try (Response response = this.client.newCall(request).execute();){
            if (response.body() != null) {
                queryResponses = this.extractQueryResponse(response.body().string());
            }
        }
        return queryResponses;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FetchResponse fetch(FetchRequest fetchRequest) throws IOException {
        String url = this.buildUrl(fetchRequest.getIndexName(), EndPoints.FETCH.toString());
        Request request = this.prepareFetchRequest(fetchRequest, url);
        try (Response response = this.client.newCall(request).execute();){
            if (response.body() != null) {
                FetchResponse fetchResponse2 = this.extractFetchResponse(response.body().string());
                return fetchResponse2;
            }
            FetchResponse fetchResponse = null;
            return fetchResponse;
        }
        catch (IOException e) {
            LOG.error("Error fetching vector for ids: {}", (Object)fetchRequest.getIds(), (Object)e);
            throw e;
        }
    }

    public String upsert(@NotNull UpsertRequest upsertRequest) throws IOException {
        String url = this.buildUrl(upsertRequest.getIndexName(), EndPoints.UPSERT.toString());
        Request request = this.prepareUpsertRequest(upsertRequest, url);
        try (Response response = this.client.newCall(request).execute();){
            if (response.body() != null) {
                String string = response.body().string();
                return string;
            }
            String string = null;
            return string;
        }
    }

    public String delete(DeleteRequest deleteRequest) throws IOException {
        String url = this.buildUrl(deleteRequest.getIndexName(), EndPoints.DELETE.toString());
        Request request = this.preparDeletelRequest(deleteRequest, url);
        try (Response response = this.client.newCall(request).execute();){
            if (response.body() != null) {
                String string = response.body().string();
                return string;
            }
            String string = null;
            return string;
        }
    }

    @NotNull
    public List<QueryResponse> extractQueryResponse(String jsonResponseString) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(jsonResponseString);
        ArrayList<QueryResponse> queryResponses = new ArrayList<QueryResponse>();
        JsonNode matches = rootNode.get("matches");
        if (matches != null && matches.isArray()) {
            for (JsonNode match : matches) {
                QueryResponse queryResponse = new QueryResponse();
                queryResponse.setId(UUID.fromString(match.get("id").asText()));
                queryResponse.setScore(match.get("score").asDouble());
                ArrayList<Double> valuesList = new ArrayList<Double>();
                match.get("values").forEach(value -> valuesList.add(value.asDouble()));
                queryResponse.setValues(valuesList);
                queryResponse.setMetadata(match.get("metadata").toString());
                queryResponses.add(queryResponse);
            }
        }
        return queryResponses;
    }

    private FetchResponse extractFetchResponse(String jsonResponseString) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(jsonResponseString);
        FetchResponse fetchResponse = new FetchResponse();
        JsonNode vectors = rootNode.get("vectors");
        String id = (String)vectors.fieldNames().next();
        JsonNode vector = vectors.get(id);
        fetchResponse.setId(UUID.fromString(vector.get("id").asText()));
        JsonNode valuesJson = vector.get("values");
        ObjectMapper objectMapper = new ObjectMapper();
        List values = null;
        try {
            values = (List)objectMapper.readValue(valuesJson.toString(), (TypeReference)new TypeReference<List<Double>>(){});
        }
        catch (JsonProcessingException e) {
            LOG.error("Error parsing values for id: {}", (Object)id, (Object)e);
        }
        fetchResponse.setValues(values);
        fetchResponse.setNameSpace(rootNode.get("namespace").toString());
        fetchResponse.setMetadata(vector.get("metadata").toString());
        return fetchResponse;
    }

    @NotNull
    private Request prepareRequestWithNoBody(String indexName, String url) {
        try {
            Request.Builder builder = new Request.Builder().url(url).addHeader("accept", "application/json").addHeader("content-type", "application/json").addHeader("Api-Key", this.apiKey);
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode json = objectMapper.createObjectNode();
            json.put("namespace", indexName);
            json.put("indexname", indexName);
            builder.post(RequestBody.create((byte[])new byte[0], null));
            return builder.build();
        }
        catch (Exception e) {
            LOG.error("Error building request for index: {}", (Object)indexName, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private Request prepareQueryRequest(QueryRequest queryRequest, String url) {
        try {
            Request.Builder builder = new Request.Builder().url(url).addHeader("accept", "application/json").addHeader("content-type", "application/json").addHeader("Api-Key", this.apiKey);
            ObjectMapper objectMapper = new ObjectMapper();
            String queryJsonString = objectMapper.writeValueAsString((Object)queryRequest);
            LOG.info("Query JSON: {}", (Object)queryJsonString);
            RequestBody body = RequestBody.create((String)queryJsonString, (MediaType)MediaType.parse((String)"application/json"));
            builder.post(body);
            return builder.build();
        }
        catch (Exception e) {
            LOG.error("Error building Query request for index: {}", (Object)queryRequest.getIndexName(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private Request prepareUpsertRequest(UpsertRequest upsertRequest, String url) {
        try {
            Request.Builder builder = new Request.Builder().url(url).addHeader("accept", "application/json").addHeader("content-type", "application/json").addHeader("Api-Key", this.apiKey);
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode json = objectMapper.createObjectNode();
            json.put("namespace", upsertRequest.getNamespace());
            MediaType mediaType = MediaType.parse((String)"application/json");
            builder.post(RequestBody.create((String)String.valueOf(upsertRequest.toString()), (MediaType)mediaType));
            return builder.build();
        }
        catch (Exception e) {
            LOG.error("Error building Upsert request for index: {}", (Object)upsertRequest.getIndexName(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private Request preparDeletelRequest(DeleteRequest deleteRequest, String url) {
        try {
            Request.Builder builder = new Request.Builder().url(url).addHeader("accept", "application/json").addHeader("content-type", "application/json").addHeader("Api-Key", this.apiKey);
            return builder.build();
        }
        catch (Exception e) {
            LOG.error("Error building Delete request for Namespace: {}", (Object)deleteRequest.getNamespace(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private Request prepareFetchRequest(FetchRequest fetchRequest, String url) {
        try {
            HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)url)).newBuilder();
            urlBuilder.addQueryParameter("ids", fetchRequest.getIDsAsString());
            urlBuilder.addQueryParameter("namespace", fetchRequest.getNameSpace());
            Request.Builder builder = new Request.Builder().url(urlBuilder.build().toString()).method("GET", null).addHeader("accept", "application/json").addHeader("content-type", "application/json").addHeader("Api-Key", this.apiKey);
            return builder.build();
        }
        catch (Exception e) {
            LOG.error("Error building Fetch request for Namespace: {}", (Object)fetchRequest.getNameSpace(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private String buildUrl(String indexName, String endpoint) {
        return String.format("https://%s-%s.svc.%s.pinecone.io/%s", indexName, this.projectId, this.environment, endpoint);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum EndPoints {
        DESCRIBE_INDEX_STATS{

            public String toString() {
                return "describe_index_stats";
            }
        }
        ,
        QUERY{

            public String toString() {
                return "query";
            }
        }
        ,
        UPSERT{

            public String toString() {
                return "vectors/upsert";
            }
        }
        ,
        DELETE{

            public String toString() {
                return "vectors/delete";
            }
        }
        ,
        FETCH{

            public String toString() {
                return "vectors/fetch";
            }
        };

    }
}

