/*
 * Decompiled with CFR 0.152.
 */
package io.clue2solve.pinecone.javaclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.clue2solve.pinecone.javaclient.model.ConfigureIndexRequest;
import io.clue2solve.pinecone.javaclient.model.CreateCollectionRequest;
import io.clue2solve.pinecone.javaclient.model.CreateIndexRequest;
import io.clue2solve.pinecone.javaclient.utils.OkHttpClientWrapper;
import io.clue2solve.pinecone.javaclient.utils.OkHttpLoggingInterceptor;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class PineconeIndexClient {
    private final OkHttpClientWrapper client;
    private final ObjectMapper objectMapper;
    private final String baseUrl;
    private final String collectionsBaseURL = "https://controller.us-west4-gcp.pinecone.io/collections";
    private final String apiKey;

    public PineconeIndexClient(String environment, String apiKey) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new OkHttpLoggingInterceptor()).build();
        this.client = new OkHttpClientWrapper(okHttpClient);
        this.objectMapper = new ObjectMapper();
        this.baseUrl = "https://controller." + environment + ".pinecone.io/databases";
        this.apiKey = apiKey;
    }

    public String listIndexes() throws IOException {
        return this.executeRequest(new Request.Builder().url(this.baseUrl).addHeader("Api-Key", this.apiKey).build());
    }

    public String createIndex(CreateIndexRequest createIndexRequest) throws IOException {
        return this.executeRequest(this.createJsonRequest(createIndexRequest, this.baseUrl, "POST"));
    }

    public String deleteIndex(String indexName) throws IOException {
        return this.executeRequest(new Request.Builder().url(this.baseUrl + "/" + indexName).delete().addHeader("Api-Key", this.apiKey).build());
    }

    public String describeIndex(String indexName) throws IOException {
        return this.executeRequest(new Request.Builder().url(this.baseUrl + "/" + indexName).addHeader("Api-Key", this.apiKey).build());
    }

    public String configureIndex(String indexName, ConfigureIndexRequest configureIndexRequest) throws IOException {
        return this.executeRequest(this.createJsonRequest(configureIndexRequest, this.baseUrl + "/" + indexName, "PATCH"));
    }

    public String listCollections() throws IOException {
        return this.executeRequest(new Request.Builder().url("https://controller.us-west4-gcp.pinecone.io/collections").addHeader("Api-Key", this.apiKey).build());
    }

    public String createCollection(CreateCollectionRequest createCollectionRequest) throws IOException {
        return this.executeRequest(this.createJsonRequest(createCollectionRequest, "https://controller.us-west4-gcp.pinecone.io/collections", "POST"));
    }

    public String describeCollection(String collectionName) throws IOException {
        return this.executeRequest(new Request.Builder().url("https://controller.us-west4-gcp.pinecone.io/collections/" + collectionName).addHeader("Api-Key", this.apiKey).build());
    }

    public String deleteCollection(String collectionName) throws IOException {
        return this.executeRequest(new Request.Builder().url("https://controller.us-west4-gcp.pinecone.io/collections/" + collectionName).delete().addHeader("Api-Key", this.apiKey).build());
    }

    private String executeRequest(Request request) throws IOException {
        try (Response response = this.client.newCall(request).execute();){
            String string = response.body() != null ? response.body().string() : null;
            return string;
        }
    }

    private Request createJsonRequest(Object requestObject, String url, String method) throws IOException {
        MediaType mediaType = MediaType.parse((String)"application/json");
        String json = this.objectMapper.writeValueAsString(requestObject);
        RequestBody body = RequestBody.create((String)json, (MediaType)mediaType);
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("accept", "text/plain").addHeader("content-type", "application/json").addHeader("Api-Key", this.apiKey);
        switch (method.toUpperCase()) {
            case "POST": {
                requestBuilder.post(body);
                break;
            }
            case "PATCH": {
                requestBuilder.patch(body);
                break;
            }
            case "PUT": {
                requestBuilder.put(body);
            }
        }
        return requestBuilder.build();
    }
}

