/*
 * Decompiled with CFR 0.152.
 */
package io.clue2solve.pinecone.javaclient.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;

public class QueryRequest {
    @NonNull
    private String namespace;
    @NonNull
    private String indexName;
    @NonNull
    private List<Double> vector;
    private boolean includeMetadata;
    private boolean includeValues;
    private int top_k = 10;

    public String getRequestAsJson() {
        ObjectMapper objectMapper = new ObjectMapper();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("namespace", this.getNamespace());
        map.put("indexname", this.getIndexName());
        map.put("includeValues", this.isIncludeValues());
        map.put("includeMetadata", this.isIncludeMetadata());
        map.put("top_k", this.getTop_k());
        map.put("vector", this.getVector());
        try {
            return objectMapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getRequestAsJson();
    }

    public static QueryRequestBuilder builder() {
        return new QueryRequestBuilder();
    }

    @NonNull
    public String getNamespace() {
        return this.namespace;
    }

    @NonNull
    public String getIndexName() {
        return this.indexName;
    }

    @NonNull
    public List<Double> getVector() {
        return this.vector;
    }

    public boolean isIncludeMetadata() {
        return this.includeMetadata;
    }

    public boolean isIncludeValues() {
        return this.includeValues;
    }

    public int getTop_k() {
        return this.top_k;
    }

    public void setNamespace(@NonNull String namespace) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        this.namespace = namespace;
    }

    public void setIndexName(@NonNull String indexName) {
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        this.indexName = indexName;
    }

    public void setVector(@NonNull List<Double> vector) {
        if (vector == null) {
            throw new NullPointerException("vector is marked non-null but is null");
        }
        this.vector = vector;
    }

    public void setIncludeMetadata(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    public void setIncludeValues(boolean includeValues) {
        this.includeValues = includeValues;
    }

    public void setTop_k(int top_k) {
        this.top_k = top_k;
    }

    public QueryRequest() {
    }

    public QueryRequest(@NonNull String namespace, @NonNull String indexName, @NonNull List<Double> vector, boolean includeMetadata, boolean includeValues, int top_k) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (vector == null) {
            throw new NullPointerException("vector is marked non-null but is null");
        }
        this.namespace = namespace;
        this.indexName = indexName;
        this.vector = vector;
        this.includeMetadata = includeMetadata;
        this.includeValues = includeValues;
        this.top_k = top_k;
    }

    public static class QueryRequestBuilder {
        private String namespace;
        private String indexName;
        private List<Double> vector;
        private boolean includeMetadata;
        private boolean includeValues;
        private int top_k;

        QueryRequestBuilder() {
        }

        public QueryRequestBuilder namespace(@NonNull String namespace) {
            if (namespace == null) {
                throw new NullPointerException("namespace is marked non-null but is null");
            }
            this.namespace = namespace;
            return this;
        }

        public QueryRequestBuilder indexName(@NonNull String indexName) {
            if (indexName == null) {
                throw new NullPointerException("indexName is marked non-null but is null");
            }
            this.indexName = indexName;
            return this;
        }

        public QueryRequestBuilder vector(@NonNull List<Double> vector) {
            if (vector == null) {
                throw new NullPointerException("vector is marked non-null but is null");
            }
            this.vector = vector;
            return this;
        }

        public QueryRequestBuilder includeMetadata(boolean includeMetadata) {
            this.includeMetadata = includeMetadata;
            return this;
        }

        public QueryRequestBuilder includeValues(boolean includeValues) {
            this.includeValues = includeValues;
            return this;
        }

        public QueryRequestBuilder top_k(int top_k) {
            this.top_k = top_k;
            return this;
        }

        public QueryRequest build() {
            return new QueryRequest(this.namespace, this.indexName, this.vector, this.includeMetadata, this.includeValues, this.top_k);
        }

        public String toString() {
            return "QueryRequest.QueryRequestBuilder(namespace=" + this.namespace + ", indexName=" + this.indexName + ", vector=" + String.valueOf(this.vector) + ", includeMetadata=" + this.includeMetadata + ", includeValues=" + this.includeValues + ", top_k=" + this.top_k + ")";
        }
    }
}

