/*
 * Decompiled with CFR 0.152.
 */
package io.clue2solve.pinecone.javaclient.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    static Logger LOG = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public static String toPrettyFormat(String jsonString) {
        if (jsonString.isEmpty()) {
            return "";
        }
        try {
            Object json = mapper.readValue(jsonString, Object.class);
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
        }
        catch (Exception e) {
            LOG.error("Unable to pretty print JSON", (Throwable)e);
            return jsonString;
        }
    }
}

