/*
 * Decompiled with CFR 0.152.
 */
package io.clue2solve.pinecone.javaclient.utils;

import io.clue2solve.pinecone.javaclient.utils.JsonUtils;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpLoggingInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger((String)"okhttp3.OkHttpClient");

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long t1 = System.nanoTime();
        Headers headers = request.headers().newBuilder().set("Api-Key", "SNIP").build();
        logger.info("Sending request: {}\n{}", (Object)request.url(), (Object)headers);
        String requestBody = null;
        if (request.body() != null) {
            Buffer requestBuffer = new Buffer();
            request.body().writeTo((BufferedSink)requestBuffer);
            requestBody = requestBuffer.readUtf8();
            logger.info("Request Body:\n------\n{}\n------", (Object)(requestBody != null ? JsonUtils.toPrettyFormat(requestBody) : null));
        }
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        Headers responseHeaders = response.headers().newBuilder().removeAll("Api-Key").build();
        logger.info("Received response for {} in {}ms\n{}", new Object[]{response.request().url(), (t2 - t1) / 1000000L, responseHeaders});
        MediaType contentType = response.body().contentType();
        String content = response.body().string();
        logger.info("Response body:\n------\n{}\n------", (Object)JsonUtils.toPrettyFormat(content));
        ResponseBody wrappedBody = ResponseBody.create((MediaType)contentType, (String)content);
        return response.newBuilder().body(wrappedBody).build();
    }
}

