/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.scanner.decisionrecords;

import io.contextmap.model.DecisionRecordOverview;
import io.contextmap.scanner.decisionrecords.DecisionRecordVisitor;
import io.contextmap.scanner.versioncontrol.VersionControlLogger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public class DecisionRecordsScanner {
    private static final int MAX_NR_OF_DECISION_RECORDS = 100;
    private final VersionControlLogger logger;

    public DecisionRecordsScanner(VersionControlLogger logger) {
        this.logger = logger;
    }

    public List<DecisionRecordOverview> scan(Path baseDir) {
        try {
            DecisionRecordVisitor visitor = new DecisionRecordVisitor();
            Files.walkFileTree(baseDir, visitor);
            List<DecisionRecordOverview> decisionRecords = visitor.getDecisionRecords();
            if (decisionRecords.size() > 100) {
                this.logger.warn("Maximum number of decision records is 100, some will be ignored");
                while (decisionRecords.size() > 100) {
                    decisionRecords.remove(0);
                }
            }
            return decisionRecords;
        }
        catch (Exception e) {
            this.logger.warn("Unable to scan for decision records");
            return Collections.emptyList();
        }
    }
}

