/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.scanner.decisionrecords;

import io.contextmap.model.FeatureFileOverview;
import io.contextmap.scanner.decisionrecords.FeatureFileVisitor;
import io.contextmap.scanner.versioncontrol.VersionControlLogger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public class FeatureFilesScanner {
    private static final int MAX_NR_OF_FEATURE_FILES = 100;
    private final VersionControlLogger logger;

    public FeatureFilesScanner(VersionControlLogger logger) {
        this.logger = logger;
    }

    public List<FeatureFileOverview> scan(Path baseDir) {
        try {
            FeatureFileVisitor visitor = new FeatureFileVisitor(baseDir);
            Files.walkFileTree(baseDir, visitor);
            List<FeatureFileOverview> featureFiles = visitor.getResults();
            if (featureFiles.size() > 100) {
                this.logger.warn("Maximum number of feature files is 100, some will be ignored");
                while (featureFiles.size() > 100) {
                    featureFiles.remove(0);
                }
            }
            return featureFiles;
        }
        catch (Exception e) {
            this.logger.warn("Unable to scan for feature files: " + e.getMessage());
            return Collections.emptyList();
        }
    }
}

