/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.external;

import cronapp.framework.authentication.external.AcceptAllTrustmanager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptAllSSLSocketFactory
extends SocketFactory {
    private static final Logger logger = LoggerFactory.getLogger(AcceptAllSSLSocketFactory.class);
    private static final AtomicReference<AcceptAllSSLSocketFactory> defaultFactory = new AtomicReference();
    private SSLSocketFactory sf;

    public AcceptAllSSLSocketFactory() {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{new AcceptAllTrustmanager()}, new SecureRandom());
            this.sf = ctx.getSocketFactory();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public static synchronized SocketFactory getDefault() {
        AcceptAllSSLSocketFactory value = defaultFactory.get();
        if (value == null) {
            defaultFactory.compareAndSet(null, new AcceptAllSSLSocketFactory());
            return defaultFactory.get();
        }
        return value;
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException {
        return this.sf.createSocket(s, i);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException {
        return this.sf.createSocket(s, i, inetAddress, i1);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        return this.sf.createSocket(inetAddress, i);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        return this.sf.createSocket(inetAddress, i, inetAddress1, i1);
    }
}

