/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.external;

import cronapi.AppConfig;
import cronapp.framework.authentication.external.BasedInLdapAuthenticator;
import cronapp.framework.i18n.Messages;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;

class LdapAuthenticator
extends BasedInLdapAuthenticator {
    LdapAuthenticator() {
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Assert.isInstanceOf(UsernamePasswordAuthenticationToken.class, (Object)authentication, (String)"Only UsernamePasswordAuthenticationToken is supported");
        UsernamePasswordAuthenticationToken userToken = (UsernamePasswordAuthenticationToken)authentication;
        String providerUrl = this.generateProviderUrl();
        String credentials = userToken.getCredentials().toString();
        String principal = userToken.getPrincipal().toString() + "@" + AppConfig.defaultDomain();
        String alternativePrincipal = "uid=" + userToken.getPrincipal().toString() + "," + AppConfig.defaultDomain();
        if (super.authenticate(providerUrl, AppConfig.defaultDomain().contains("=") ? alternativePrincipal : principal, credentials)) {
            return authentication;
        }
        throw new BadCredentialsException(Messages.getString("UserOrPassordInvalids"));
    }
}

