/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.mutual;

import cronapi.TokenUtils;
import cronapi.Var;
import cronapp.framework.api.ApiManager;
import cronapp.framework.api.User;
import cronapp.framework.authentication.token.AuthenticationController;
import cronapp.framework.authentication.token.AuthenticationResponse;
import cronapp.framework.i18n.Messages;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mobile.device.LiteDeviceResolver;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"mutual"})
public class MutualAuthenticationController {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final AuthenticationController authenticationController;

    @Autowired
    public MutualAuthenticationController(HttpServletRequest request, HttpServletResponse response, AuthenticationController authenticationController) {
        this.request = request;
        this.response = response;
        this.authenticationController = authenticationController;
    }

    @RequestMapping(value={"login"}, method={RequestMethod.POST})
    public ResponseEntity<AuthenticationResponse> login() {
        String providerKey = this.request.getHeader("SSL_CLIENT_S_DN");
        LiteDeviceResolver deviceResolver = new LiteDeviceResolver();
        Var user = ApiManager.getUserFromProvider("mutual", providerKey);
        if (user == null) {
            throw new UsernameNotFoundException(Messages.getString("UserNotFound"));
        }
        return this.authenticationController.authenticationRequest(user.getField("userName").getObjectAsString(), user.getField("password").getObjectAsString(), deviceResolver.resolveDevice(this.request), null, this.request, this.response);
    }

    @RequestMapping(value={"register"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void register(String token) throws Exception {
        String providerKey = this.request.getHeader("SSL_CLIENT_S_DN");
        ApiManager apiManager = ApiManager.byUser(TokenUtils.getUsernameFromToken((String)token));
        User user = apiManager.getUser();
        if (user == null) {
            throw new UsernameNotFoundException(Messages.getString("UserNotFound"));
        }
        apiManager.setProviderInfo("mutual", providerKey);
    }
}

