/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.saml;

import cronapi.Var;
import cronapp.framework.SessionListener;
import cronapp.framework.api.EventsManager;
import cronapp.framework.authentication.saml.SamlProperties;
import cronapp.framework.authentication.saml.SamlUserDetailsService;
import cronapp.framework.authentication.token.CorsFilter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.Filter;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mobile.device.DeviceHandlerMethodArgumentResolver;
import org.springframework.mobile.device.DeviceResolverHandlerInterceptor;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.saml.SAMLAuthenticationProvider;
import org.springframework.security.saml.SAMLBootstrap;
import org.springframework.security.saml.context.SAMLContextProvider;
import org.springframework.security.saml.context.SAMLContextProviderImpl;
import org.springframework.security.saml.key.JKSKeyManager;
import org.springframework.security.saml.log.SAMLDefaultLogger;
import org.springframework.security.saml.metadata.CachingMetadataManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.MetadataGenerator;
import org.springframework.security.saml.processor.HTTPArtifactBinding;
import org.springframework.security.saml.processor.HTTPPAOS11Binding;
import org.springframework.security.saml.processor.HTTPPostBinding;
import org.springframework.security.saml.processor.HTTPRedirectDeflateBinding;
import org.springframework.security.saml.processor.HTTPSOAP11Binding;
import org.springframework.security.saml.processor.SAMLBinding;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.processor.SAMLProcessorImpl;
import org.springframework.security.saml.storage.EmptyStorageFactory;
import org.springframework.security.saml.storage.SAMLMessageStorageFactory;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;
import org.springframework.security.saml.util.VelocityFactory;
import org.springframework.security.saml.websso.ArtifactResolutionProfile;
import org.springframework.security.saml.websso.ArtifactResolutionProfileImpl;
import org.springframework.security.saml.websso.SingleLogoutProfile;
import org.springframework.security.saml.websso.SingleLogoutProfileImpl;
import org.springframework.security.saml.websso.WebSSOProfile;
import org.springframework.security.saml.websso.WebSSOProfileConsumerHoKImpl;
import org.springframework.security.saml.websso.WebSSOProfileConsumerImpl;
import org.springframework.security.saml.websso.WebSSOProfileECPImpl;
import org.springframework.security.saml.websso.WebSSOProfileImpl;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class SamlConfigurer
implements WebMvcConfigurer {
    private Timer backgroundTaskTimer;
    private MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager;
    @Value(value="${security.oauth2.saml.maxAuthenticationAge:#{null}}")
    private Long maxAuthenticationAge;

    @PostConstruct
    public void startup() throws GeneralSecurityException, IOException {
        this.backgroundTaskTimer = new Timer(true);
        this.multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
        System.setProperty("org.opensaml.httpclient.https.disableHostnameVerification", "true");
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443));
    }

    @PreDestroy
    public void shutdown() {
        this.backgroundTaskTimer.purge();
        this.backgroundTaskTimer.cancel();
        this.multiThreadedHttpConnectionManager.shutdown();
    }

    @Bean
    public FilterRegistrationBean<CorsFilter> configureFilters() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new CorsFilter());
        registrationBean.setOrder(-2147483646);
        return registrationBean;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void doSomethingAfterStartup() {
        if (EventsManager.hasEvent("onSystemStarts")) {
            EventsManager.executeEventOnTransaction("onSystemStarts", new Var[0]);
        }
    }

    @Bean
    public ServletListenerRegistrationBean<HttpSessionListener> sessionListener() {
        return new ServletListenerRegistrationBean((java.util.EventListener)((Object)new SessionListener()));
    }

    @Bean
    public DeviceResolverHandlerInterceptor deviceResolverHandlerInterceptor() {
        return new DeviceResolverHandlerInterceptor();
    }

    @Bean
    public DeviceHandlerMethodArgumentResolver deviceHandlerMethodArgumentResolver() {
        return new DeviceHandlerMethodArgumentResolver();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.deviceResolverHandlerInterceptor());
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add((HandlerMethodArgumentResolver)this.deviceHandlerMethodArgumentResolver());
    }

    @Bean
    public MetadataGenerator metadataGenerator(SamlProperties samlProperties) {
        MetadataGenerator metadataGenerator = new MetadataGenerator();
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setIdpDiscoveryEnabled(true);
        metadataGenerator.setExtendedMetadata(extendedMetadata);
        metadataGenerator.setEntityId(samlProperties.getEntityId());
        return metadataGenerator;
    }

    @Bean
    @ConfigurationProperties(prefix="security.oauth2.saml")
    SamlProperties samlProperties() {
        return new SamlProperties();
    }

    @Bean
    public SAMLContextProvider contextProvider() {
        SAMLContextProviderImpl samlContextProvider = new SAMLContextProviderImpl();
        samlContextProvider.setStorageFactory((SAMLMessageStorageFactory)new EmptyStorageFactory());
        return samlContextProvider;
    }

    @Bean
    public JKSKeyManager keyManager(SamlProperties samlProperties) {
        HashMap<String, String> passwords = new HashMap<String, String>();
        passwords.put(samlProperties.getPrivateKey(), samlProperties.getPrivateKeyPass());
        return new JKSKeyManager((Resource)new ClassPathResource(samlProperties.getStoreFile()), samlProperties.getStorePass(), passwords, samlProperties.getPrivateKey());
    }

    @Bean
    public HTTPMetadataProvider httpMetadataProvider(ParserPool parserPool, HttpClient httpClient, SamlProperties samlProperties) throws Exception {
        HTTPMetadataProvider metadataProvider = new HTTPMetadataProvider(this.backgroundTaskTimer, httpClient, samlProperties.getMetadataUrl());
        metadataProvider.setParserPool(parserPool);
        return metadataProvider;
    }

    @Bean
    public CachingMetadataManager metadata(List<MetadataProvider> providers) throws Exception {
        return new CachingMetadataManager(providers);
    }

    @Bean
    public SAMLDefaultLogger samlLogger() {
        return new SAMLDefaultLogger();
    }

    @Bean
    public static SAMLBootstrap samlBootstrap() {
        return new SAMLBootstrap();
    }

    @Bean
    public WebSSOProfile webSSOprofile() {
        return new WebSSOProfileImpl();
    }

    @Bean
    public SAMLProcessorImpl processor() {
        ArrayList<Object> bindings = new ArrayList<Object>();
        bindings.add(this.httpRedirectDeflateBinding());
        bindings.add(this.httpPostBinding());
        bindings.add(this.artifactBinding((ParserPool)this.parserPool(), this.velocityEngine()));
        bindings.add(this.httpSOAP11Binding());
        bindings.add(this.httpPAOS11Binding());
        return new SAMLProcessorImpl(bindings);
    }

    private ArtifactResolutionProfile artifactResolutionProfile() {
        ArtifactResolutionProfileImpl artifactResolutionProfile = new ArtifactResolutionProfileImpl(this.httpClient());
        artifactResolutionProfile.setProcessor((SAMLProcessor)new SAMLProcessorImpl((SAMLBinding)this.soapBinding()));
        return artifactResolutionProfile;
    }

    @Bean
    public VelocityEngine velocityEngine() {
        return VelocityFactory.getEngine();
    }

    @Bean(initMethod="initialize")
    public StaticBasicParserPool parserPool() {
        return new StaticBasicParserPool();
    }

    @Bean
    public HttpClient httpClient() {
        return new HttpClient((HttpConnectionManager)this.multiThreadedHttpConnectionManager);
    }

    @Bean
    public HTTPArtifactBinding artifactBinding(ParserPool parserPool, VelocityEngine velocityEngine) {
        return new HTTPArtifactBinding(parserPool, velocityEngine, this.artifactResolutionProfile());
    }

    @Bean
    public HTTPSOAP11Binding soapBinding() {
        return new HTTPSOAP11Binding((ParserPool)this.parserPool());
    }

    @Bean
    public HTTPPostBinding httpPostBinding() {
        return new HTTPPostBinding((ParserPool)this.parserPool(), this.velocityEngine());
    }

    @Bean
    public HTTPRedirectDeflateBinding httpRedirectDeflateBinding() {
        return new HTTPRedirectDeflateBinding((ParserPool)this.parserPool());
    }

    @Bean
    public HTTPSOAP11Binding httpSOAP11Binding() {
        return new HTTPSOAP11Binding((ParserPool)this.parserPool());
    }

    @Bean
    public HTTPPAOS11Binding httpPAOS11Binding() {
        return new HTTPPAOS11Binding((ParserPool)this.parserPool());
    }

    @Bean
    public SingleLogoutProfile singleLogoutProfile() {
        return new SingleLogoutProfileImpl();
    }

    @Bean
    public AuthenticationProvider samlAuthenticationProvider() {
        SAMLAuthenticationProvider samlAuthenticationProvider = new SAMLAuthenticationProvider();
        samlAuthenticationProvider.setUserDetails((SAMLUserDetailsService)new SamlUserDetailsService());
        samlAuthenticationProvider.setForcePrincipalAsString(false);
        return samlAuthenticationProvider;
    }

    @Bean
    WebSSOProfileConsumerImpl webSSOprofileConsumer() {
        WebSSOProfileConsumerImpl webSSOProfileConsumer = new WebSSOProfileConsumerImpl();
        if (this.maxAuthenticationAge != null) {
            webSSOProfileConsumer.setMaxAuthenticationAge(this.maxAuthenticationAge.longValue());
        }
        return webSSOProfileConsumer;
    }

    @Bean
    public WebSSOProfileConsumerHoKImpl hokWebSSOprofileConsumer() {
        return new WebSSOProfileConsumerHoKImpl();
    }

    @Bean
    public WebSSOProfileConsumerHoKImpl hokWebSSOProfile() {
        return new WebSSOProfileConsumerHoKImpl();
    }

    @Bean
    public WebSSOProfileECPImpl ecpprofile() {
        return new WebSSOProfileECPImpl();
    }
}

