/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.sso;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import cronapi.Var;
import cronapi.screen.Operations;
import cronapp.framework.api.ApiManager;
import cronapp.framework.api.EventsManager;
import cronapp.framework.authentication.security.CronappUserDetails;
import cronapp.framework.authentication.sso.CustomAuthoritiesExtractor;
import cronapp.framework.authentication.sso.CustomPrincipalExtractor;
import cronapp.framework.authentication.token.AuthenticationController;
import cronapp.framework.authentication.token.AuthenticationResponse;
import cronapp.framework.i18n.Messages;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2SsoProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoRestTemplateFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.mobile.device.LiteDeviceResolver;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.filter.OAuth2ClientAuthenticationProcessingFilter;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;

class SsoSecurityConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SsoSecurityConfigurer.class);
    private final ApplicationContext applicationContext;

    SsoSecurityConfigurer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    void configure(HttpSecurity http) throws Exception {
        OAuth2SsoProperties sso = (OAuth2SsoProperties)this.applicationContext.getBean(OAuth2SsoProperties.class);
        http.apply((SecurityConfigurerAdapter)new OAuth2ClientAuthenticationConfigurer(this.oauth2SsoFilter(sso)));
        this.addAuthenticationEntryPoint(http, sso);
    }

    private void addAuthenticationEntryPoint(HttpSecurity http, OAuth2SsoProperties sso) throws Exception {
        ExceptionHandlingConfigurer exceptions = http.exceptionHandling();
        ContentNegotiationStrategy contentNegotiationStrategy = (ContentNegotiationStrategy)http.getSharedObject(ContentNegotiationStrategy.class);
        if (contentNegotiationStrategy == null) {
            contentNegotiationStrategy = new HeaderContentNegotiationStrategy();
        }
        MediaTypeRequestMatcher preferredMatcher = new MediaTypeRequestMatcher(contentNegotiationStrategy, new MediaType[]{MediaType.APPLICATION_XHTML_XML, new MediaType("image", "*"), MediaType.TEXT_HTML, MediaType.TEXT_PLAIN});
        preferredMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        exceptions.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(sso.getLoginPath()), (RequestMatcher)preferredMatcher);
        exceptions.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED), (RequestMatcher)new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest"));
    }

    private OAuth2ClientAuthenticationProcessingFilter oauth2SsoFilter(OAuth2SsoProperties sso) {
        OAuth2RestTemplate restTemplate = ((UserInfoRestTemplateFactory)this.applicationContext.getBean(UserInfoRestTemplateFactory.class)).getUserInfoRestTemplate();
        UserInfoTokenServices tokenServices = (UserInfoTokenServices)this.applicationContext.getBean(UserInfoTokenServices.class);
        CustomPrincipalExtractor principalExtractor = new CustomPrincipalExtractor();
        tokenServices.setAuthoritiesExtractor((AuthoritiesExtractor)new CustomAuthoritiesExtractor(principalExtractor));
        tokenServices.setPrincipalExtractor((PrincipalExtractor)principalExtractor);
        OAuth2ClientAuthenticationProcessingFilter filter = new OAuth2ClientAuthenticationProcessingFilter(sso.getLoginPath());
        filter.setRestTemplate((OAuth2RestOperations)restTemplate);
        filter.setTokenServices((ResourceServerTokenServices)tokenServices);
        filter.setApplicationEventPublisher((ApplicationEventPublisher)this.applicationContext);
        filter.setAuthenticationSuccessHandler(this.successHandler());
        filter.setAuthenticationFailureHandler(this.failureHandler());
        return filter;
    }

    private AuthenticationSuccessHandler successHandler() {
        return (request, response, authentication) -> {
            UsernamePasswordAuthenticationToken userAuthentication = (UsernamePasswordAuthenticationToken)((OAuth2Authentication)authentication).getUserAuthentication();
            CronappUserDetails externalUserDetails = SsoSecurityConfigurer.getCronappUserDetails(userAuthentication);
            try {
                Gson gson = new Gson();
                JsonObject json = (JsonObject)gson.toJsonTree((Object)externalUserDetails);
                LiteDeviceResolver deviceResolver = new LiteDeviceResolver();
                AuthenticationController authenticationController = new AuthenticationController(null);
                String accessToken = String.valueOf(request.getAttribute(OAuth2AuthenticationDetails.ACCESS_TOKEN_VALUE));
                Operations.addTokenClaim((Var)Var.valueOf((Object)"SSOAccessToken"), (Var)Var.valueOf((Object)accessToken));
                ResponseEntity<AuthenticationResponse> authenticationRequest = authenticationController.auth(externalUserDetails.getEmail(), "cronapp", deviceResolver.resolveDevice(request), "SSO", null, json, request, response);
                String redirect = "/auth/signin/sso?_ctk=" + ((AuthenticationResponse)authenticationRequest.getBody()).getToken();
                response.sendRedirect(redirect);
            }
            catch (Exception e) {
                throw new AuthenticationServiceException(Messages.getString("AuthError", e.getMessage()));
            }
            if (EventsManager.hasEvent("onLogin")) {
                EventsManager.executeEventOnTransaction("onLogin", Var.valueOf((String)"username", (Object)authentication.getName()));
            }
        };
    }

    private AuthenticationFailureHandler failureHandler() {
        return (request, response, failureHandler) -> {
            Object e = failureHandler;
            for (int nivel = 0; e != null && nivel < 3; e = e.getCause(), ++nivel) {
                LOGGER.error("Falha obter token OAUTH", (Object)e.getMessage(), e);
            }
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
        };
    }

    private static String getAttributeString(Map<String, Object> details, String name) {
        if (details == null) {
            return null;
        }
        Object rawAttribute = details.get(name);
        if (rawAttribute == null) {
            return null;
        }
        return rawAttribute.toString();
    }

    public static CronappUserDetails getCronappUserDetails(UsernamePasswordAuthenticationToken userAuthentication) {
        String defaultPrincipal;
        Map details = (Map)userAuthentication.getDetails();
        String userName = defaultPrincipal = String.valueOf(userAuthentication.getPrincipal());
        String normalizedUserName = ApiManager.normalize(userName);
        Object email = SsoSecurityConfigurer.getAttributeString(details, "email");
        String normalizedEmail = ApiManager.normalize((String)email);
        String phone = SsoSecurityConfigurer.getAttributeString(details, "phone");
        if (StringUtils.isEmpty((CharSequence)phone)) {
            phone = "N/A";
        }
        if (StringUtils.isEmpty((CharSequence)email)) {
            email = normalizedUserName + "@no-email";
        }
        if (StringUtils.isEmpty((CharSequence)normalizedEmail)) {
            normalizedEmail = ApiManager.normalize((String)email);
        }
        return CronappUserDetails.newBuilder().setName((String)StringUtils.defaultIfEmpty((CharSequence)SsoSecurityConfigurer.getAttributeString(details, "name"), (CharSequence)userName)).setUserName(userName).setNormalizedUserName(normalizedUserName).setEmail((String)email).setNormalizedEmail(normalizedEmail).setEmailConfirmed(true).setSecurityStamp(UUID.randomUUID().toString()).setPhoneNumber(phone).setPhoneNumberConfirmed(true).setTwoFactorEnabled(false).setLockoutEnd(OffsetDateTime.MIN).setLockoutEnabled(false).setAccessFailedCount(0).setAuthorities(Collections.unmodifiableSet(new LinkedHashSet(userAuthentication.getAuthorities()))).build();
    }

    private static class OAuth2ClientAuthenticationConfigurer
    extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
        private OAuth2ClientAuthenticationProcessingFilter filter;

        OAuth2ClientAuthenticationConfigurer(OAuth2ClientAuthenticationProcessingFilter filter) {
            this.filter = filter;
        }

        public void configure(HttpSecurity builder) {
            OAuth2ClientAuthenticationProcessingFilter ssoFilter = this.filter;
            ssoFilter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)builder.getSharedObject(SessionAuthenticationStrategy.class));
            builder.addFilterAfter((Filter)ssoFilter, AbstractPreAuthenticatedProcessingFilter.class);
        }
    }
}

