/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import com.google.protobuf.MessageOrBuilder;
import io.deephaven.api.SortColumn;
import io.deephaven.api.agg.spec.AggSpec;
import io.deephaven.api.agg.spec.AggSpecAbsSum;
import io.deephaven.api.agg.spec.AggSpecApproximatePercentile;
import io.deephaven.api.agg.spec.AggSpecAvg;
import io.deephaven.api.agg.spec.AggSpecCountDistinct;
import io.deephaven.api.agg.spec.AggSpecDistinct;
import io.deephaven.api.agg.spec.AggSpecFirst;
import io.deephaven.api.agg.spec.AggSpecFormula;
import io.deephaven.api.agg.spec.AggSpecFreeze;
import io.deephaven.api.agg.spec.AggSpecGroup;
import io.deephaven.api.agg.spec.AggSpecLast;
import io.deephaven.api.agg.spec.AggSpecMax;
import io.deephaven.api.agg.spec.AggSpecMedian;
import io.deephaven.api.agg.spec.AggSpecMin;
import io.deephaven.api.agg.spec.AggSpecPercentile;
import io.deephaven.api.agg.spec.AggSpecSortedFirst;
import io.deephaven.api.agg.spec.AggSpecSortedLast;
import io.deephaven.api.agg.spec.AggSpecStd;
import io.deephaven.api.agg.spec.AggSpecSum;
import io.deephaven.api.agg.spec.AggSpecTDigest;
import io.deephaven.api.agg.spec.AggSpecUnique;
import io.deephaven.api.agg.spec.AggSpecVar;
import io.deephaven.api.agg.spec.AggSpecWAvg;
import io.deephaven.api.agg.spec.AggSpecWSum;
import io.deephaven.api.object.UnionObject;
import io.deephaven.proto.backplane.grpc.AggSpec;
import io.deephaven.proto.backplane.grpc.NullValue;
import java.util.Objects;
import java.util.function.BiFunction;

class AggSpecBuilder
implements AggSpec.Visitor {
    private io.deephaven.proto.backplane.grpc.AggSpec out;

    AggSpecBuilder() {
    }

    public static io.deephaven.proto.backplane.grpc.AggSpec adapt(AggSpec aggSpec) {
        return ((AggSpecBuilder)aggSpec.walk((AggSpec.Visitor)new AggSpecBuilder())).out();
    }

    io.deephaven.proto.backplane.grpc.AggSpec out() {
        return Objects.requireNonNull(this.out);
    }

    private static <T extends MessageOrBuilder> io.deephaven.proto.backplane.grpc.AggSpec spec(BiFunction<AggSpec.Builder, T, AggSpec.Builder> setter, T obj) {
        return setter.apply(io.deephaven.proto.backplane.grpc.AggSpec.newBuilder(), (AggSpec.Builder)obj).build();
    }

    public void visit(AggSpecAbsSum absSum) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setAbsSum, AggSpec.AggSpecAbsSum.newBuilder());
    }

    public void visit(AggSpecApproximatePercentile approxPct) {
        AggSpec.AggSpecApproximatePercentile.Builder builder = AggSpec.AggSpecApproximatePercentile.newBuilder().setPercentile(approxPct.percentile());
        approxPct.compression().ifPresent(arg_0 -> ((AggSpec.AggSpecApproximatePercentile.Builder)builder).setCompression(arg_0));
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setApproximatePercentile, builder);
    }

    public void visit(AggSpecAvg avg) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setAvg, AggSpec.AggSpecAvg.newBuilder());
    }

    public void visit(AggSpecCountDistinct countDistinct) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setCountDistinct, AggSpec.AggSpecCountDistinct.newBuilder().setCountNulls(countDistinct.countNulls()));
    }

    public void visit(AggSpecDistinct distinct) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setDistinct, AggSpec.AggSpecDistinct.newBuilder().setIncludeNulls(distinct.includeNulls()));
    }

    public void visit(AggSpecFirst first) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setFirst, AggSpec.AggSpecFirst.newBuilder());
    }

    public void visit(AggSpecFormula formula) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setFormula, AggSpec.AggSpecFormula.newBuilder().setFormula(formula.formula()).setParamToken(formula.paramToken()));
    }

    public void visit(AggSpecFreeze freeze) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setFreeze, AggSpec.AggSpecFreeze.newBuilder());
    }

    public void visit(AggSpecGroup group) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setGroup, AggSpec.AggSpecGroup.newBuilder());
    }

    public void visit(AggSpecLast last) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setLast, AggSpec.AggSpecLast.newBuilder());
    }

    public void visit(AggSpecMax max) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setMax, AggSpec.AggSpecMax.newBuilder());
    }

    public void visit(AggSpecMedian median) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setMedian, AggSpec.AggSpecMedian.newBuilder().setAverageEvenlyDivided(median.averageEvenlyDivided()));
    }

    public void visit(AggSpecMin min) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setMin, AggSpec.AggSpecMin.newBuilder());
    }

    public void visit(AggSpecPercentile pct) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setPercentile, AggSpec.AggSpecPercentile.newBuilder().setPercentile(pct.percentile()).setAverageEvenlyDivided(pct.averageEvenlyDivided()));
    }

    private static AggSpec.AggSpecSortedColumn adapt(SortColumn sortColumn) {
        return AggSpec.AggSpecSortedColumn.newBuilder().setColumnName(sortColumn.column().name()).build();
    }

    public void visit(AggSpecSortedFirst sortedFirst) {
        AggSpec.AggSpecSorted.Builder builder = AggSpec.AggSpecSorted.newBuilder();
        for (SortColumn column : sortedFirst.columns()) {
            builder.addColumns(AggSpecBuilder.adapt(column));
        }
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setSortedFirst, builder);
    }

    public void visit(AggSpecSortedLast sortedLast) {
        AggSpec.AggSpecSorted.Builder builder = AggSpec.AggSpecSorted.newBuilder();
        for (SortColumn column : sortedLast.columns()) {
            builder.addColumns(AggSpecBuilder.adapt(column));
        }
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setSortedLast, builder);
    }

    public void visit(AggSpecStd std) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setStd, AggSpec.AggSpecStd.newBuilder());
    }

    public void visit(AggSpecSum sum) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setSum, AggSpec.AggSpecSum.newBuilder());
    }

    public void visit(AggSpecTDigest tDigest) {
        AggSpec.AggSpecTDigest.Builder builder = AggSpec.AggSpecTDigest.newBuilder();
        tDigest.compression().ifPresent(arg_0 -> ((AggSpec.AggSpecTDigest.Builder)builder).setCompression(arg_0));
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setTDigest, builder);
    }

    public void visit(AggSpecUnique unique) {
        AggSpec.AggSpecUnique.Builder builder = AggSpec.AggSpecUnique.newBuilder().setIncludeNulls(unique.includeNulls()).setNonUniqueSentinel(AggSpecBuilder.adapt(unique.nonUniqueSentinel().orElse(null)));
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setUnique, builder);
    }

    private static AggSpec.AggSpecNonUniqueSentinel adapt(UnionObject obj) {
        return obj == null ? AggSpec.AggSpecNonUniqueSentinel.newBuilder().setNullValue(NullValue.NULL_VALUE).build() : (AggSpec.AggSpecNonUniqueSentinel)obj.visit((UnionObject.Visitor)AggSpecNonUniqueSentinelAdapter.INSTANCE);
    }

    public void visit(AggSpecWAvg wAvg) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setWeightedAvg, AggSpec.AggSpecWeighted.newBuilder().setWeightColumn(wAvg.weight().name()));
    }

    public void visit(AggSpecWSum wSum) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setWeightedSum, AggSpec.AggSpecWeighted.newBuilder().setWeightColumn(wSum.weight().name()));
    }

    public void visit(AggSpecVar var) {
        this.out = AggSpecBuilder.spec(AggSpec.Builder::setVar, AggSpec.AggSpecVar.newBuilder());
    }

    public static enum AggSpecNonUniqueSentinelAdapter implements UnionObject.Visitor<AggSpec.AggSpecNonUniqueSentinel>
    {
        INSTANCE;


        public AggSpec.AggSpecNonUniqueSentinel visit(boolean x) {
            return AggSpec.AggSpecNonUniqueSentinel.newBuilder().setBoolValue(x).build();
        }

        public AggSpec.AggSpecNonUniqueSentinel visit(char x) {
            return AggSpec.AggSpecNonUniqueSentinel.newBuilder().setCharValue((int)x).build();
        }

        public AggSpec.AggSpecNonUniqueSentinel visit(byte x) {
            return AggSpec.AggSpecNonUniqueSentinel.newBuilder().setByteValue((int)x).build();
        }

        public AggSpec.AggSpecNonUniqueSentinel visit(short x) {
            return AggSpec.AggSpecNonUniqueSentinel.newBuilder().setShortValue((int)x).build();
        }

        public AggSpec.AggSpecNonUniqueSentinel visit(int x) {
            return AggSpec.AggSpecNonUniqueSentinel.newBuilder().setIntValue(x).build();
        }

        public AggSpec.AggSpecNonUniqueSentinel visit(long x) {
            return AggSpec.AggSpecNonUniqueSentinel.newBuilder().setLongValue(x).build();
        }

        public AggSpec.AggSpecNonUniqueSentinel visit(float x) {
            return AggSpec.AggSpecNonUniqueSentinel.newBuilder().setFloatValue(x).build();
        }

        public AggSpec.AggSpecNonUniqueSentinel visit(double x) {
            return AggSpec.AggSpecNonUniqueSentinel.newBuilder().setDoubleValue(x).build();
        }

        public AggSpec.AggSpecNonUniqueSentinel visit(Object x) {
            if (x instanceof String) {
                return AggSpec.AggSpecNonUniqueSentinel.newBuilder().setStringValue((String)x).build();
            }
            throw new IllegalArgumentException(String.format("Unable to adapt AggSpecNonUniqueSentinel type %s", x.getClass()));
        }
    }
}

