/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import com.google.protobuf.ByteStringAccess;
import io.deephaven.api.ColumnName;
import io.deephaven.api.JoinAddition;
import io.deephaven.api.JoinMatch;
import io.deephaven.api.RawString;
import io.deephaven.api.Selectable;
import io.deephaven.api.SortColumn;
import io.deephaven.api.Strings;
import io.deephaven.api.expression.Expression;
import io.deephaven.api.expression.Function;
import io.deephaven.api.expression.Method;
import io.deephaven.api.filter.Filter;
import io.deephaven.api.literal.Literal;
import io.deephaven.api.snapshot.SnapshotWhenOptions;
import io.deephaven.client.impl.AggSpecBuilder;
import io.deephaven.client.impl.AggregationBuilder;
import io.deephaven.client.impl.FilterAdapter;
import io.deephaven.client.impl.SchemaBytes;
import io.deephaven.client.impl.UpdateByBuilder;
import io.deephaven.proto.backplane.grpc.AggregateAllRequest;
import io.deephaven.proto.backplane.grpc.AggregateRequest;
import io.deephaven.proto.backplane.grpc.Aggregation;
import io.deephaven.proto.backplane.grpc.AjRajTablesRequest;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.CreateInputTableRequest;
import io.deephaven.proto.backplane.grpc.CrossJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.DropColumnsRequest;
import io.deephaven.proto.backplane.grpc.EmptyTableRequest;
import io.deephaven.proto.backplane.grpc.ExactJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.FetchTableRequest;
import io.deephaven.proto.backplane.grpc.FilterTableRequest;
import io.deephaven.proto.backplane.grpc.HeadOrTailRequest;
import io.deephaven.proto.backplane.grpc.MergeTablesRequest;
import io.deephaven.proto.backplane.grpc.MultiJoinInput;
import io.deephaven.proto.backplane.grpc.MultiJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.NaturalJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.RangeJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.Reference;
import io.deephaven.proto.backplane.grpc.SelectDistinctRequest;
import io.deephaven.proto.backplane.grpc.SelectOrUpdateRequest;
import io.deephaven.proto.backplane.grpc.SliceRequest;
import io.deephaven.proto.backplane.grpc.SnapshotTableRequest;
import io.deephaven.proto.backplane.grpc.SnapshotWhenTableRequest;
import io.deephaven.proto.backplane.grpc.SortDescriptor;
import io.deephaven.proto.backplane.grpc.SortTableRequest;
import io.deephaven.proto.backplane.grpc.TableReference;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.backplane.grpc.TimeTableRequest;
import io.deephaven.proto.backplane.grpc.UngroupRequest;
import io.deephaven.proto.backplane.grpc.UnstructuredFilterTableRequest;
import io.deephaven.proto.backplane.grpc.UpdateByRequest;
import io.deephaven.proto.backplane.grpc.Value;
import io.deephaven.proto.backplane.grpc.WhereInRequest;
import io.deephaven.proto.util.ExportTicketHelper;
import io.deephaven.qst.table.AggregateAllTable;
import io.deephaven.qst.table.AggregateTable;
import io.deephaven.qst.table.AsOfJoinTable;
import io.deephaven.qst.table.BlinkInputTable;
import io.deephaven.qst.table.Clock;
import io.deephaven.qst.table.ClockSystem;
import io.deephaven.qst.table.DropColumnsTable;
import io.deephaven.qst.table.EmptyTable;
import io.deephaven.qst.table.ExactJoinTable;
import io.deephaven.qst.table.HeadTable;
import io.deephaven.qst.table.InMemoryAppendOnlyInputTable;
import io.deephaven.qst.table.InMemoryKeyBackedInputTable;
import io.deephaven.qst.table.InputTable;
import io.deephaven.qst.table.JoinTable;
import io.deephaven.qst.table.LazyUpdateTable;
import io.deephaven.qst.table.MergeTable;
import io.deephaven.qst.table.MultiJoinTable;
import io.deephaven.qst.table.NaturalJoinTable;
import io.deephaven.qst.table.NewTable;
import io.deephaven.qst.table.RangeJoinTable;
import io.deephaven.qst.table.ReverseTable;
import io.deephaven.qst.table.SelectDistinctTable;
import io.deephaven.qst.table.SelectTable;
import io.deephaven.qst.table.SingleParentTable;
import io.deephaven.qst.table.SliceTable;
import io.deephaven.qst.table.SnapshotTable;
import io.deephaven.qst.table.SnapshotWhenTable;
import io.deephaven.qst.table.SortTable;
import io.deephaven.qst.table.TableHeader;
import io.deephaven.qst.table.TableSchema;
import io.deephaven.qst.table.TableSpec;
import io.deephaven.qst.table.TailTable;
import io.deephaven.qst.table.TicketTable;
import io.deephaven.qst.table.TimeTable;
import io.deephaven.qst.table.UngroupTable;
import io.deephaven.qst.table.UpdateByTable;
import io.deephaven.qst.table.UpdateTable;
import io.deephaven.qst.table.UpdateViewTable;
import io.deephaven.qst.table.ViewTable;
import io.deephaven.qst.table.WhereInTable;
import io.deephaven.qst.table.WhereTable;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;

class BatchTableRequestBuilder {
    BatchTableRequestBuilder() {
    }

    static BatchTableRequest buildNoChecks(ExportLookup lookup, Collection<TableSpec> postOrder) {
        HashMap<TableSpec, Integer> indices = new HashMap<TableSpec, Integer>(postOrder.size());
        BatchTableRequest.Builder builder = BatchTableRequest.newBuilder();
        int ix = 0;
        for (TableSpec table : postOrder) {
            OptionalInt exportId = lookup.ticket(table);
            Ticket ticket = exportId.isPresent() ? ExportTicketHelper.wrapExportIdInTicket((int)exportId.getAsInt()) : Ticket.getDefaultInstance();
            BatchTableRequest.Operation operation = (BatchTableRequest.Operation)table.walk((TableSpec.Visitor)new OperationAdapter(ticket, indices, lookup));
            builder.addOps(operation);
            indices.put(table, ix++);
        }
        return builder.build();
    }

    private static <T> BatchTableRequest.Operation op(BiFunction<BatchTableRequest.Operation.Builder, T, BatchTableRequest.Operation.Builder> f, T value) {
        return f.apply(BatchTableRequest.Operation.newBuilder(), (BatchTableRequest.Operation.Builder)value).build();
    }

    static Reference reference(ColumnName columnName) {
        return Reference.newBuilder().setColumnName(columnName.name()).build();
    }

    private static io.deephaven.proto.backplane.grpc.Literal literal(long x) {
        return io.deephaven.proto.backplane.grpc.Literal.newBuilder().setLongValue(x).build();
    }

    private static io.deephaven.proto.backplane.grpc.Literal literal(boolean x) {
        return io.deephaven.proto.backplane.grpc.Literal.newBuilder().setBoolValue(x).build();
    }

    private static io.deephaven.proto.backplane.grpc.Literal literal(double x) {
        return io.deephaven.proto.backplane.grpc.Literal.newBuilder().setDoubleValue(x).build();
    }

    private static io.deephaven.proto.backplane.grpc.Literal literal(String x) {
        return io.deephaven.proto.backplane.grpc.Literal.newBuilder().setStringValue(x).build();
    }

    static interface ExportLookup {
        public OptionalInt ticket(TableSpec var1);
    }

    private static class OperationAdapter
    implements TableSpec.Visitor<BatchTableRequest.Operation> {
        private final Ticket ticket;
        private final Map<TableSpec, Integer> indices;
        private final ExportLookup lookup;

        OperationAdapter(Ticket ticket, Map<TableSpec, Integer> indices, ExportLookup lookup) {
            this.ticket = Objects.requireNonNull(ticket);
            this.indices = Objects.requireNonNull(indices);
            this.lookup = Objects.requireNonNull(lookup);
        }

        private TableReference ref(TableSpec table) {
            OptionalInt existing = this.lookup.ticket(table);
            if (existing.isPresent()) {
                return ExportTicketHelper.tableReference((int)existing.getAsInt());
            }
            Integer ix = this.indices.get(table);
            if (ix != null) {
                return TableReference.newBuilder().setBatchOffset(ix.intValue()).build();
            }
            throw new IllegalStateException("Unable to reference table - batch table request logic has a bug.");
        }

        public BatchTableRequest.Operation visit(EmptyTable emptyTable) {
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setEmptyTable, EmptyTableRequest.newBuilder().setResultId(this.ticket).setSize(emptyTable.size()));
        }

        public BatchTableRequest.Operation visit(NewTable newTable) {
            throw new UnsupportedOperationException("TODO(deephaven-core#992): TableService implementation of NewTable, https://github.com/deephaven/deephaven-core/issues/992");
        }

        public BatchTableRequest.Operation visit(TimeTable timeTable) {
            timeTable.clock().walk((Clock.Visitor)new Clock.Visitor<Void>(){

                public Void visit(ClockSystem system) {
                    return null;
                }
            });
            TimeTableRequest.Builder builder = TimeTableRequest.newBuilder().setResultId(this.ticket).setPeriodNanos(timeTable.interval().toNanos()).setBlinkTable(timeTable.blinkTable());
            if (timeTable.startTime().isPresent()) {
                Instant startTime = (Instant)timeTable.startTime().get();
                long epochNanos = Math.addExact(TimeUnit.SECONDS.toNanos(startTime.getEpochSecond()), (long)startTime.getNano());
                builder.setStartTimeNanos(epochNanos);
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setTimeTable, builder.build());
        }

        public BatchTableRequest.Operation visit(MergeTable mergeTable) {
            MergeTablesRequest.Builder builder = MergeTablesRequest.newBuilder().setResultId(this.ticket);
            for (TableSpec table : mergeTable.tables()) {
                builder.addSourceIds(this.ref(table));
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setMerge, builder.build());
        }

        public BatchTableRequest.Operation visit(HeadTable headTable) {
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setHead, HeadOrTailRequest.newBuilder().setResultId(this.ticket).setSourceId(this.ref(headTable.parent())).setNumRows(headTable.size()));
        }

        public BatchTableRequest.Operation visit(TailTable tailTable) {
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setTail, HeadOrTailRequest.newBuilder().setResultId(this.ticket).setSourceId(this.ref(tailTable.parent())).setNumRows(tailTable.size()));
        }

        public BatchTableRequest.Operation visit(SliceTable sliceTable) {
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setSlice, SliceRequest.newBuilder().setResultId(this.ticket).setSourceId(this.ref(sliceTable.parent())).setFirstPositionInclusive(sliceTable.firstPositionInclusive()).setLastPositionExclusive(sliceTable.lastPositionExclusive()).build());
        }

        public BatchTableRequest.Operation visit(ReverseTable reverseTable) {
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setSort, SortTableRequest.newBuilder().setResultId(this.ticket).setSourceId(this.ref(reverseTable.parent())).addSorts(SortDescriptor.newBuilder().setDirection(SortDescriptor.SortDirection.REVERSE).build()).build());
        }

        public BatchTableRequest.Operation visit(SortTable sortTable) {
            SortTableRequest.Builder builder = SortTableRequest.newBuilder().setResultId(this.ticket).setSourceId(this.ref(sortTable.parent()));
            for (SortColumn column : sortTable.columns()) {
                SortDescriptor descriptor = SortDescriptor.newBuilder().setColumnName(column.column().name()).setDirection(column.isAscending() ? SortDescriptor.SortDirection.ASCENDING : SortDescriptor.SortDirection.DESCENDING).build();
                builder.addSorts(descriptor);
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setSort, builder.build());
        }

        public BatchTableRequest.Operation visit(SnapshotTable snapshotTable) {
            SnapshotTableRequest.Builder builder = SnapshotTableRequest.newBuilder().setResultId(this.ticket).setSourceId(this.ref(snapshotTable.parent()));
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setSnapshot, builder.build());
        }

        public BatchTableRequest.Operation visit(SnapshotWhenTable snapshotWhenTable) {
            SnapshotWhenOptions options = snapshotWhenTable.options();
            SnapshotWhenTableRequest.Builder builder = SnapshotWhenTableRequest.newBuilder().setResultId(this.ticket).setBaseId(this.ref(snapshotWhenTable.base())).setTriggerId(this.ref(snapshotWhenTable.trigger())).setInitial(options.has(SnapshotWhenOptions.Flag.INITIAL)).setIncremental(options.has(SnapshotWhenOptions.Flag.INCREMENTAL)).setHistory(options.has(SnapshotWhenOptions.Flag.HISTORY));
            for (JoinAddition stampColumn : options.stampColumns()) {
                builder.addStampColumns(Strings.of((JoinAddition)stampColumn));
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setSnapshotWhen, builder.build());
        }

        private BatchTableRequest.Operation createFilterTableRequest(WhereTable whereTable) {
            FilterTableRequest.Builder builder = FilterTableRequest.newBuilder().setResultId(this.ticket).setSourceId(this.ref(whereTable.parent()));
            for (Filter filter : Filter.extractAnds((Filter)whereTable.filter())) {
                builder.addFilters(FilterAdapter.of(filter));
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setFilter, builder.build());
        }

        private BatchTableRequest.Operation createUnstructuredFilterTableRequest(WhereTable whereTable) {
            UnstructuredFilterTableRequest.Builder builder = UnstructuredFilterTableRequest.newBuilder().setResultId(this.ticket).setSourceId(this.ref(whereTable.parent()));
            for (Filter filter : Filter.extractAnds((Filter)whereTable.filter())) {
                builder.addFilters(Strings.of((Filter)filter));
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setUnstructuredFilter, builder.build());
        }

        public BatchTableRequest.Operation visit(WhereTable whereTable) {
            try {
                return this.createFilterTableRequest(whereTable);
            }
            catch (UnsupportedOperationException uoe) {
                return this.createUnstructuredFilterTableRequest(whereTable);
            }
        }

        public BatchTableRequest.Operation visit(WhereInTable whereInTable) {
            WhereInRequest.Builder builder = WhereInRequest.newBuilder().setResultId(this.ticket).setLeftId(this.ref(whereInTable.left())).setRightId(this.ref(whereInTable.right())).setInverted(whereInTable.inverted());
            for (JoinMatch match : whereInTable.matches()) {
                builder.addColumnsToMatch(Strings.of((JoinMatch)match));
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setWhereIn, builder.build());
        }

        public BatchTableRequest.Operation visit(NaturalJoinTable j) {
            NaturalJoinTablesRequest.Builder builder = NaturalJoinTablesRequest.newBuilder().setResultId(this.ticket).setLeftId(this.ref(j.left())).setRightId(this.ref(j.right()));
            for (JoinMatch match : j.matches()) {
                builder.addColumnsToMatch(Strings.of((JoinMatch)match));
            }
            for (JoinAddition addition : j.additions()) {
                builder.addColumnsToAdd(Strings.of((JoinAddition)addition));
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setNaturalJoin, builder.build());
        }

        public BatchTableRequest.Operation visit(ExactJoinTable j) {
            ExactJoinTablesRequest.Builder builder = ExactJoinTablesRequest.newBuilder().setResultId(this.ticket).setLeftId(this.ref(j.left())).setRightId(this.ref(j.right()));
            for (JoinMatch match : j.matches()) {
                builder.addColumnsToMatch(Strings.of((JoinMatch)match));
            }
            for (JoinAddition addition : j.additions()) {
                builder.addColumnsToAdd(Strings.of((JoinAddition)addition));
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setExactJoin, builder.build());
        }

        public BatchTableRequest.Operation visit(JoinTable j) {
            CrossJoinTablesRequest.Builder builder = CrossJoinTablesRequest.newBuilder().setResultId(this.ticket).setLeftId(this.ref(j.left())).setRightId(this.ref(j.right()));
            j.reserveBits().ifPresent(arg_0 -> ((CrossJoinTablesRequest.Builder)builder).setReserveBits(arg_0));
            for (JoinMatch match : j.matches()) {
                builder.addColumnsToMatch(Strings.of((JoinMatch)match));
            }
            for (JoinAddition addition : j.additions()) {
                builder.addColumnsToAdd(Strings.of((JoinAddition)addition));
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setCrossJoin, builder.build());
        }

        public BatchTableRequest.Operation visit(AsOfJoinTable asOfJoin) {
            AjRajTablesRequest.Builder builder = AjRajTablesRequest.newBuilder().setResultId(this.ticket).setLeftId(this.ref(asOfJoin.left())).setRightId(this.ref(asOfJoin.right()));
            for (JoinMatch match : asOfJoin.matches()) {
                builder.addExactMatchColumns(Strings.of((JoinMatch)match));
            }
            builder.setAsOfColumn(asOfJoin.joinMatch().toRpcString());
            for (JoinAddition addition : asOfJoin.additions()) {
                builder.addColumnsToAdd(Strings.of((JoinAddition)addition));
            }
            return BatchTableRequestBuilder.op(asOfJoin.isAj() ? BatchTableRequest.Operation.Builder::setAj : BatchTableRequest.Operation.Builder::setRaj, builder.build());
        }

        public BatchTableRequest.Operation visit(RangeJoinTable rangeJoinTable) {
            RangeJoinTablesRequest.RangeEndRule rangeEndRule;
            RangeJoinTablesRequest.RangeStartRule rangeStartRule;
            RangeJoinTablesRequest.Builder builder = RangeJoinTablesRequest.newBuilder().setResultId(this.ticket).setLeftId(this.ref(rangeJoinTable.left())).setRightId(this.ref(rangeJoinTable.right()));
            for (JoinMatch exactMatch : rangeJoinTable.exactMatches()) {
                builder.addExactMatchColumns(Strings.of((JoinMatch)exactMatch));
            }
            builder.setLeftStartColumn(Strings.of((ColumnName)rangeJoinTable.rangeMatch().leftStartColumn()));
            switch (rangeJoinTable.rangeMatch().rangeStartRule()) {
                case LESS_THAN: {
                    rangeStartRule = RangeJoinTablesRequest.RangeStartRule.LESS_THAN;
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    rangeStartRule = RangeJoinTablesRequest.RangeStartRule.LESS_THAN_OR_EQUAL;
                    break;
                }
                case LESS_THAN_OR_EQUAL_ALLOW_PRECEDING: {
                    rangeStartRule = RangeJoinTablesRequest.RangeStartRule.LESS_THAN_OR_EQUAL_ALLOW_PRECEDING;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unrecognized range start rule %s for range join", rangeJoinTable.rangeMatch().rangeStartRule()));
                }
            }
            builder.setRangeStartRule(rangeStartRule);
            builder.setRightRangeColumn(Strings.of((ColumnName)rangeJoinTable.rangeMatch().rightRangeColumn()));
            switch (rangeJoinTable.rangeMatch().rangeEndRule()) {
                case GREATER_THAN: {
                    rangeEndRule = RangeJoinTablesRequest.RangeEndRule.GREATER_THAN;
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    rangeEndRule = RangeJoinTablesRequest.RangeEndRule.GREATER_THAN_OR_EQUAL;
                    break;
                }
                case GREATER_THAN_OR_EQUAL_ALLOW_FOLLOWING: {
                    rangeEndRule = RangeJoinTablesRequest.RangeEndRule.GREATER_THAN_OR_EQUAL_ALLOW_FOLLOWING;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unrecognized range end rule %s for range join", rangeJoinTable.rangeMatch().rangeEndRule()));
                }
            }
            builder.setRangeEndRule(rangeEndRule);
            builder.setLeftEndColumn(Strings.of((ColumnName)rangeJoinTable.rangeMatch().leftEndColumn()));
            for (io.deephaven.api.agg.Aggregation aggregation : rangeJoinTable.aggregations()) {
                for (Aggregation adapted : AggregationBuilder.adapt(aggregation)) {
                    builder.addAggregations(adapted);
                }
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setRangeJoin, builder.build());
        }

        public BatchTableRequest.Operation visit(ViewTable v) {
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setView, this.selectOrUpdate((SingleParentTable)v, v.columns()));
        }

        public BatchTableRequest.Operation visit(UpdateViewTable v) {
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setUpdateView, this.selectOrUpdate((SingleParentTable)v, v.columns()));
        }

        public BatchTableRequest.Operation visit(UpdateTable v) {
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setUpdate, this.selectOrUpdate((SingleParentTable)v, v.columns()));
        }

        public BatchTableRequest.Operation visit(LazyUpdateTable v) {
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setLazyUpdate, this.selectOrUpdate((SingleParentTable)v, v.columns()));
        }

        public BatchTableRequest.Operation visit(SelectTable v) {
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setSelect, this.selectOrUpdate((SingleParentTable)v, v.columns()));
        }

        public BatchTableRequest.Operation visit(AggregateAllTable aggregateAllTable) {
            AggregateAllRequest.Builder builder = AggregateAllRequest.newBuilder().setResultId(this.ticket).setSourceId(this.ref(aggregateAllTable.parent())).setSpec(AggSpecBuilder.adapt(aggregateAllTable.spec()));
            for (ColumnName column : aggregateAllTable.groupByColumns()) {
                builder.addGroupByColumns(Strings.of((ColumnName)column));
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setAggregateAll, builder.build());
        }

        public BatchTableRequest.Operation visit(AggregateTable aggregateTable) {
            AggregateRequest.Builder builder = AggregateRequest.newBuilder().setResultId(this.ticket).setSourceId(this.ref(aggregateTable.parent())).setPreserveEmpty(aggregateTable.preserveEmpty());
            aggregateTable.initialGroups().map(this::ref).ifPresent(arg_0 -> ((AggregateRequest.Builder)builder).setInitialGroupsId(arg_0));
            for (io.deephaven.api.agg.Aggregation aggregation : aggregateTable.aggregations()) {
                for (Aggregation adapted : AggregationBuilder.adapt(aggregation)) {
                    builder.addAggregations(adapted);
                }
            }
            for (ColumnName column : aggregateTable.groupByColumns()) {
                builder.addGroupByColumns(Strings.of((ColumnName)column));
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setAggregate, builder.build());
        }

        public BatchTableRequest.Operation visit(TicketTable ticketTable) {
            Ticket sourceTicket = Ticket.newBuilder().setTicket(ByteStringAccess.wrap((byte[])ticketTable.ticket())).build();
            TableReference sourceReference = TableReference.newBuilder().setTicket(sourceTicket).build();
            FetchTableRequest.Builder builder = FetchTableRequest.newBuilder().setResultId(this.ticket).setSourceId(sourceReference);
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setFetchTable, builder);
        }

        public BatchTableRequest.Operation visit(InputTable inputTable) {
            final CreateInputTableRequest.Builder builder = CreateInputTableRequest.newBuilder().setResultId(this.ticket);
            inputTable.schema().walk((TableSchema.Visitor)new TableSchema.Visitor<Void>(){

                public Void visit(TableSpec spec) {
                    builder.setSourceTableId(this.ref(spec));
                    return null;
                }

                public Void visit(TableHeader header) {
                    builder.setSchema(ByteStringAccess.wrap((byte[])SchemaBytes.of(header)));
                    return null;
                }
            });
            builder.setKind((CreateInputTableRequest.InputTableKind)inputTable.walk((InputTable.Visitor)new InputTable.Visitor<CreateInputTableRequest.InputTableKind>(){

                public CreateInputTableRequest.InputTableKind visit(InMemoryAppendOnlyInputTable inMemoryAppendOnly) {
                    return CreateInputTableRequest.InputTableKind.newBuilder().setInMemoryAppendOnly(CreateInputTableRequest.InputTableKind.InMemoryAppendOnly.newBuilder()).build();
                }

                public CreateInputTableRequest.InputTableKind visit(InMemoryKeyBackedInputTable inMemoryKeyBacked) {
                    return CreateInputTableRequest.InputTableKind.newBuilder().setInMemoryKeyBacked(CreateInputTableRequest.InputTableKind.InMemoryKeyBacked.newBuilder().addAllKeyColumns((Iterable)inMemoryKeyBacked.keys())).build();
                }

                public CreateInputTableRequest.InputTableKind visit(BlinkInputTable blinkInputTable) {
                    return CreateInputTableRequest.InputTableKind.newBuilder().setBlink(CreateInputTableRequest.InputTableKind.Blink.getDefaultInstance()).build();
                }
            }));
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setCreateInputTable, builder);
        }

        public BatchTableRequest.Operation visit(SelectDistinctTable selectDistinctTable) {
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setSelectDistinct, this.selectDistinct(selectDistinctTable));
        }

        public BatchTableRequest.Operation visit(UpdateByTable updateByTable) {
            UpdateByRequest.Builder request = UpdateByBuilder.adapt(updateByTable).setResultId(this.ticket).setSourceId(this.ref(updateByTable.parent()));
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setUpdateBy, request);
        }

        public BatchTableRequest.Operation visit(UngroupTable ungroupTable) {
            UngroupRequest.Builder request = UngroupRequest.newBuilder().setResultId(this.ticket).setSourceId(this.ref(ungroupTable.parent())).setNullFill(ungroupTable.nullFill());
            for (ColumnName ungroupColumn : ungroupTable.ungroupColumns()) {
                request.addColumnsToUngroup(ungroupColumn.name());
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setUngroup, request);
        }

        public BatchTableRequest.Operation visit(DropColumnsTable dropColumnsTable) {
            DropColumnsRequest.Builder request = DropColumnsRequest.newBuilder().setResultId(this.ticket).setSourceId(this.ref(dropColumnsTable.parent()));
            for (ColumnName dropColumn : dropColumnsTable.dropColumns()) {
                request.addColumnNames(dropColumn.name());
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setDropColumns, request);
        }

        public BatchTableRequest.Operation visit(MultiJoinTable multiJoinTable) {
            MultiJoinTablesRequest.Builder request = MultiJoinTablesRequest.newBuilder().setResultId(this.ticket);
            for (io.deephaven.qst.table.MultiJoinInput input : multiJoinTable.inputs()) {
                request.addMultiJoinInputs(this.adapt((io.deephaven.qst.table.MultiJoinInput<TableSpec>)input));
            }
            return BatchTableRequestBuilder.op(BatchTableRequest.Operation.Builder::setMultiJoin, request);
        }

        private MultiJoinInput adapt(io.deephaven.qst.table.MultiJoinInput<TableSpec> input) {
            MultiJoinInput.Builder builder = MultiJoinInput.newBuilder().setSourceId(this.ref((TableSpec)input.table()));
            for (JoinMatch match : input.matches()) {
                builder.addColumnsToMatch(Strings.of((JoinMatch)match));
            }
            for (JoinAddition addition : input.additions()) {
                builder.addColumnsToAdd(Strings.of((JoinAddition)addition));
            }
            return builder.build();
        }

        private SelectOrUpdateRequest selectOrUpdate(SingleParentTable x, Collection<Selectable> columns) {
            SelectOrUpdateRequest.Builder builder = SelectOrUpdateRequest.newBuilder().setResultId(this.ticket).setSourceId(this.ref(x.parent()));
            for (Selectable column : columns) {
                builder.addColumnSpecs(Strings.of((Selectable)column));
            }
            return builder.build();
        }

        private SelectDistinctRequest selectDistinct(SelectDistinctTable selectDistinctTable) {
            SelectDistinctRequest.Builder builder = SelectDistinctRequest.newBuilder().setResultId(this.ticket).setSourceId(this.ref(selectDistinctTable.parent()));
            for (Selectable column : selectDistinctTable.columns()) {
                builder.addColumnNames(Strings.of((Selectable)column));
            }
            return builder.build();
        }
    }

    static enum LiteralAdapter implements Literal.Visitor<io.deephaven.proto.backplane.grpc.Literal>
    {
        INSTANCE;


        public static io.deephaven.proto.backplane.grpc.Literal of(Literal literal) {
            return (io.deephaven.proto.backplane.grpc.Literal)literal.walk((Literal.Visitor)INSTANCE);
        }

        public io.deephaven.proto.backplane.grpc.Literal visit(boolean literal) {
            return BatchTableRequestBuilder.literal(literal);
        }

        public io.deephaven.proto.backplane.grpc.Literal visit(char literal) {
            throw new UnsupportedOperationException("Doesn't support char literal");
        }

        public io.deephaven.proto.backplane.grpc.Literal visit(byte literal) {
            throw new UnsupportedOperationException("Doesn't support byte literal");
        }

        public io.deephaven.proto.backplane.grpc.Literal visit(short literal) {
            throw new UnsupportedOperationException("Doesn't support short literal");
        }

        public io.deephaven.proto.backplane.grpc.Literal visit(int literal) {
            throw new UnsupportedOperationException("Doesn't support int literal");
        }

        public io.deephaven.proto.backplane.grpc.Literal visit(long literal) {
            return BatchTableRequestBuilder.literal(literal);
        }

        public io.deephaven.proto.backplane.grpc.Literal visit(float literal) {
            throw new UnsupportedOperationException("Doesn't support float literal");
        }

        public io.deephaven.proto.backplane.grpc.Literal visit(double literal) {
            return BatchTableRequestBuilder.literal(literal);
        }

        public io.deephaven.proto.backplane.grpc.Literal visit(String literal) {
            return BatchTableRequestBuilder.literal(literal);
        }
    }

    static class ExpressionAdapter
    implements Expression.Visitor<Value>,
    Literal.Visitor<Value> {
        ExpressionAdapter() {
        }

        static Value adapt(Expression expression) {
            return (Value)expression.walk((Expression.Visitor)new ExpressionAdapter());
        }

        static Value adapt(Literal literal) {
            return (Value)literal.walk((Literal.Visitor)new ExpressionAdapter());
        }

        public Value visit(ColumnName x) {
            return Value.newBuilder().setReference(BatchTableRequestBuilder.reference(x)).build();
        }

        public Value visit(char literal) {
            throw new UnsupportedOperationException("Value does not support literal char");
        }

        public Value visit(byte literal) {
            throw new UnsupportedOperationException("Value does not support literal byte");
        }

        public Value visit(short literal) {
            throw new UnsupportedOperationException("Value does not support literal short");
        }

        public Value visit(int literal) {
            throw new UnsupportedOperationException("Value does not support literal int");
        }

        public Value visit(long literal) {
            return Value.newBuilder().setLiteral(BatchTableRequestBuilder.literal(literal)).build();
        }

        public Value visit(boolean literal) {
            return Value.newBuilder().setLiteral(BatchTableRequestBuilder.literal(literal)).build();
        }

        public Value visit(float literal) {
            throw new UnsupportedOperationException("Value does not support literal float");
        }

        public Value visit(double literal) {
            return Value.newBuilder().setLiteral(BatchTableRequestBuilder.literal(literal)).build();
        }

        public Value visit(String literal) {
            return Value.newBuilder().setLiteral(BatchTableRequestBuilder.literal(literal)).build();
        }

        public Value visit(Literal literal) {
            return (Value)literal.walk((Literal.Visitor)this);
        }

        public Value visit(Filter filter) {
            throw new UnsupportedOperationException("Unable to create a io.deephaven.proto.backplane.grpc.Value from a Filter");
        }

        public Value visit(Function function) {
            throw new UnsupportedOperationException("Unable to create a io.deephaven.proto.backplane.grpc.Value from a Function");
        }

        public Value visit(Method method) {
            throw new UnsupportedOperationException("Unable to create a io.deephaven.proto.backplane.grpc.Value from a Method");
        }

        public Value visit(RawString rawString) {
            throw new UnsupportedOperationException("Unable to create a io.deephaven.proto.backplane.grpc.Value from a raw string");
        }
    }
}

