/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.TicketId;
import java.util.Objects;
import java.util.Optional;

public final class FieldInfo {
    private final io.deephaven.proto.backplane.grpc.FieldInfo fieldInfo;

    FieldInfo(io.deephaven.proto.backplane.grpc.FieldInfo fieldInfo) {
        this.fieldInfo = Objects.requireNonNull(fieldInfo);
    }

    public Optional<String> type() {
        if (this.fieldInfo.getTypedTicket().getType().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.fieldInfo.getTypedTicket().getType());
    }

    public TicketId ticket() {
        return TicketId.from(this.fieldInfo.getTypedTicket().getTicket());
    }

    public String name() {
        return this.fieldInfo.getFieldName();
    }

    public Optional<String> description() {
        return this.fieldInfo.getFieldDescription().isEmpty() ? Optional.empty() : Optional.of(this.fieldInfo.getFieldDescription());
    }

    public String applicationId() {
        return this.fieldInfo.getApplicationId();
    }

    public String applicationName() {
        return this.fieldInfo.getApplicationName();
    }

    public String toString() {
        return this.fieldInfo.toString();
    }
}

