/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.api.ColumnName;
import io.deephaven.api.RawString;
import io.deephaven.api.expression.Expression;
import io.deephaven.api.expression.Function;
import io.deephaven.api.expression.Method;
import io.deephaven.api.filter.Filter;
import io.deephaven.api.filter.FilterAnd;
import io.deephaven.api.filter.FilterComparison;
import io.deephaven.api.filter.FilterIn;
import io.deephaven.api.filter.FilterIsNaN;
import io.deephaven.api.filter.FilterIsNull;
import io.deephaven.api.filter.FilterNot;
import io.deephaven.api.filter.FilterOr;
import io.deephaven.api.filter.FilterPattern;
import io.deephaven.api.filter.FilterSerial;
import io.deephaven.api.filter.FilterWithDeclaredBarriers;
import io.deephaven.api.filter.FilterWithRespectedBarriers;
import io.deephaven.client.impl.BatchTableRequestBuilder;
import io.deephaven.proto.backplane.grpc.AndCondition;
import io.deephaven.proto.backplane.grpc.CompareCondition;
import io.deephaven.proto.backplane.grpc.Condition;
import io.deephaven.proto.backplane.grpc.InCondition;
import io.deephaven.proto.backplane.grpc.IsNaNCondition;
import io.deephaven.proto.backplane.grpc.IsNullCondition;
import io.deephaven.proto.backplane.grpc.NotCondition;
import io.deephaven.proto.backplane.grpc.OrCondition;
import io.deephaven.util.annotations.InternalUseOnly;

@InternalUseOnly
public class FilterAdapter
implements Filter.Visitor<Condition> {
    public static Condition of(Filter filter) {
        return (Condition)filter.walk((Filter.Visitor)new FilterAdapter());
    }

    private static CompareCondition.CompareOperation adapt(FilterComparison.Operator operator) {
        switch (operator) {
            case LESS_THAN: {
                return CompareCondition.CompareOperation.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return CompareCondition.CompareOperation.LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return CompareCondition.CompareOperation.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return CompareCondition.CompareOperation.GREATER_THAN_OR_EQUAL;
            }
            case EQUALS: {
                return CompareCondition.CompareOperation.EQUALS;
            }
            case NOT_EQUALS: {
                return CompareCondition.CompareOperation.NOT_EQUALS;
            }
        }
        throw new IllegalArgumentException("Unexpected operator " + String.valueOf(operator));
    }

    public Condition visit(FilterIsNull isNull) {
        if (!(isNull.expression() instanceof ColumnName)) {
            throw new UnsupportedOperationException("Only supports null checking a reference to a column");
        }
        return Condition.newBuilder().setIsNull(IsNullCondition.newBuilder().setReference(BatchTableRequestBuilder.reference((ColumnName)isNull.expression())).build()).build();
    }

    public Condition visit(FilterIsNaN isNaN) {
        if (!(isNaN.expression() instanceof ColumnName)) {
            throw new UnsupportedOperationException("Only supports NaN checking a reference to a column");
        }
        return Condition.newBuilder().setIsNan(IsNaNCondition.newBuilder().setReference(BatchTableRequestBuilder.reference((ColumnName)isNaN.expression())).build()).build();
    }

    public Condition visit(FilterComparison comparison) {
        FilterComparison preferred = comparison.maybeTranspose();
        FilterComparison.Operator operator = preferred.operator();
        switch (operator) {
            case EQUALS: {
                return this.visit(FilterIn.of((Expression)preferred.lhs(), (Expression[])new Expression[]{preferred.rhs()}));
            }
            case NOT_EQUALS: {
                return this.visit((FilterNot<?>)Filter.not((Filter)FilterIn.of((Expression)preferred.lhs(), (Expression[])new Expression[]{preferred.rhs()})));
            }
        }
        return Condition.newBuilder().setCompare(CompareCondition.newBuilder().setOperation(FilterAdapter.adapt(operator)).setLhs(BatchTableRequestBuilder.ExpressionAdapter.adapt(preferred.lhs())).setRhs(BatchTableRequestBuilder.ExpressionAdapter.adapt(preferred.rhs())).build()).build();
    }

    public Condition visit(FilterIn in) {
        InCondition.Builder builder = InCondition.newBuilder().setTarget(BatchTableRequestBuilder.ExpressionAdapter.adapt(in.expression()));
        for (Expression value : in.values()) {
            builder.addCandidates(BatchTableRequestBuilder.ExpressionAdapter.adapt(value));
        }
        return Condition.newBuilder().setIn(builder).build();
    }

    public Condition visit(FilterNot<?> not) {
        Filter invertedFilter = not.invertFilter();
        if (not.equals((Object)invertedFilter)) {
            return Condition.newBuilder().setNot(NotCondition.newBuilder().setFilter(FilterAdapter.of(not.filter())).build()).build();
        }
        return FilterAdapter.of(invertedFilter);
    }

    public Condition visit(FilterOr ors) {
        OrCondition.Builder builder = OrCondition.newBuilder();
        for (Filter filter : ors) {
            builder.addFilters(FilterAdapter.of(filter));
        }
        return Condition.newBuilder().setOr(builder.build()).build();
    }

    public Condition visit(FilterAnd ands) {
        AndCondition.Builder builder = AndCondition.newBuilder();
        for (Filter filter : ands) {
            builder.addFilters(FilterAdapter.of(filter));
        }
        return Condition.newBuilder().setAnd(builder.build()).build();
    }

    public Condition visit(FilterSerial serial) {
        throw new UnsupportedOperationException("Can't build Condition with FilterSerial");
    }

    public Condition visit(FilterWithDeclaredBarriers declaredBarrier) {
        throw new UnsupportedOperationException("Can't build Condition with FilterWithDeclaredBarriers");
    }

    public Condition visit(FilterWithRespectedBarriers respectedBarrier) {
        throw new UnsupportedOperationException("Can't build Condition with FilterWithRespectedBarriers");
    }

    public Condition visit(FilterPattern pattern) {
        throw new UnsupportedOperationException("Can't build Condition with FilterPattern");
    }

    public Condition visit(Function function) {
        throw new UnsupportedOperationException("Can't build Condition with Function");
    }

    public Condition visit(Method method) {
        throw new UnsupportedOperationException("Can't build Condition with Method");
    }

    public Condition visit(boolean literal) {
        throw new UnsupportedOperationException("Can't build Condition with literal");
    }

    public Condition visit(RawString rawString) {
        throw new UnsupportedOperationException("Can't build Condition with raw string");
    }
}

