/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class FutureHelper {
    FutureHelper() {
    }

    static <T> T getOrCancel(Future<T> future) throws InterruptedException, ExecutionException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            if (future.cancel(true)) {
                throw e;
            }
            return FutureHelper.getCompleted(future, true);
        }
    }

    static <T> T getOrCancel(Future<T> future, Duration timeout) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return future.get(timeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            if (future.cancel(true)) {
                throw e;
            }
            return FutureHelper.getCompleted(future, true);
        }
        catch (TimeoutException e) {
            if (future.cancel(true)) {
                throw e;
            }
            return FutureHelper.getCompleted(future, false);
        }
    }

    static <T> void cancelOrConsume(Iterable<? extends Future<T>> futures, FutureConsumer<T> consumer, boolean mayInterruptIfRunning) {
        for (Future<T> future : futures) {
            if (future.cancel(mayInterruptIfRunning)) continue;
            FutureHelper.consumeCompleted(future, consumer);
        }
    }

    private static <T> void consumeCompleted(Future<T> future, FutureConsumer<T> consumer) {
        T result;
        try {
            result = FutureHelper.getCompleted(future, false);
        }
        catch (ExecutionException e) {
            consumer.accept(null, e, null);
            return;
        }
        catch (CancellationException c) {
            consumer.accept(null, null, c);
            return;
        }
        consumer.accept(result, null, null);
    }

    private static <T> T getCompleted(Future<T> future, boolean interrupted) throws ExecutionException {
        while (true) {
            try {
                T t = future.get();
                return t;
            }
            catch (InterruptedException ignored) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @FunctionalInterface
    static interface FutureConsumer<T> {
        public void accept(T var1, ExecutionException var2, CancellationException var3);
    }
}

