/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.client.impl.ClientChannelFactory;
import io.deephaven.client.impl.ClientChannelFactoryDefaulter;
import io.deephaven.ssl.config.SSLConfig;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClientChannelFactoryDefaulter", generator="Immutables")
@Immutable
final class ImmutableClientChannelFactoryDefaulter
extends ClientChannelFactoryDefaulter {
    private final ClientChannelFactory delegate;
    @Nullable
    private final SSLConfig ssl;
    @Nullable
    private final String userAgent;

    private ImmutableClientChannelFactoryDefaulter(Builder builder) {
        this.ssl = builder.ssl;
        this.userAgent = builder.userAgent;
        this.delegate = builder.delegateIsSet() ? builder.delegate : Objects.requireNonNull(super.delegate(), "delegate");
    }

    @Override
    public ClientChannelFactory delegate() {
        return this.delegate;
    }

    @Override
    public Optional<SSLConfig> ssl() {
        return Optional.ofNullable(this.ssl);
    }

    @Override
    public Optional<String> userAgent() {
        return Optional.ofNullable(this.userAgent);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClientChannelFactoryDefaulter && this.equalsByValue((ImmutableClientChannelFactoryDefaulter)another);
    }

    private boolean equalsByValue(ImmutableClientChannelFactoryDefaulter another) {
        return this.delegate.equals(another.delegate) && Objects.equals(this.ssl, another.ssl) && Objects.equals(this.userAgent, another.userAgent);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.delegate.hashCode();
        h += (h << 5) + Objects.hashCode(this.ssl);
        h += (h << 5) + Objects.hashCode(this.userAgent);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ClientChannelFactoryDefaulter{");
        builder.append("delegate=").append(this.delegate);
        if (this.ssl != null) {
            builder.append(", ");
            builder.append("ssl=").append(this.ssl);
        }
        if (this.userAgent != null) {
            builder.append(", ");
            builder.append("userAgent=").append(this.userAgent);
        }
        return builder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClientChannelFactoryDefaulter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ClientChannelFactoryDefaulter.Builder {
        private static final long OPT_BIT_DELEGATE = 1L;
        private static final long OPT_BIT_SSL = 2L;
        private static final long OPT_BIT_USER_AGENT = 4L;
        private long optBits;
        @Nullable
        private ClientChannelFactory delegate;
        @Nullable
        private SSLConfig ssl;
        @Nullable
        private String userAgent;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder delegate(ClientChannelFactory delegate) {
            Builder.checkNotIsSet(this.delegateIsSet(), "delegate");
            this.delegate = Objects.requireNonNull(delegate, "delegate");
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder ssl(SSLConfig ssl) {
            Builder.checkNotIsSet(this.sslIsSet(), "ssl");
            this.ssl = Objects.requireNonNull(ssl, "ssl");
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ssl(Optional<? extends SSLConfig> ssl) {
            Builder.checkNotIsSet(this.sslIsSet(), "ssl");
            this.ssl = ssl.orElse(null);
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder userAgent(String userAgent) {
            Builder.checkNotIsSet(this.userAgentIsSet(), "userAgent");
            this.userAgent = Objects.requireNonNull(userAgent, "userAgent");
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder userAgent(Optional<String> userAgent) {
            Builder.checkNotIsSet(this.userAgentIsSet(), "userAgent");
            this.userAgent = userAgent.orElse(null);
            this.optBits |= 4L;
            return this;
        }

        @Override
        public ImmutableClientChannelFactoryDefaulter build() {
            return new ImmutableClientChannelFactoryDefaulter(this);
        }

        private boolean delegateIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sslIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean userAgentIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ClientChannelFactoryDefaulter is strict, attribute is already set: ".concat(name));
            }
        }
    }
}

