/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.client.impl.SessionConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SessionConfig", generator="Immutables")
@Immutable
final class ImmutableSessionConfig
extends SessionConfig {
    @Nullable
    private final String authenticationTypeAndValue;
    @Nullable
    private final ScheduledExecutorService scheduler;
    private final boolean delegateToBatch;
    private final boolean mixinStacktrace;
    private final Duration executeTimeout;
    private final Duration closeTimeout;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSessionConfig(Builder builder) {
        this.authenticationTypeAndValue = builder.authenticationTypeAndValue;
        this.scheduler = builder.scheduler;
        if (builder.delegateToBatchIsSet()) {
            this.initShim.delegateToBatch(builder.delegateToBatch);
        }
        if (builder.mixinStacktraceIsSet()) {
            this.initShim.mixinStacktrace(builder.mixinStacktrace);
        }
        if (builder.executeTimeoutIsSet()) {
            this.initShim.executeTimeout(builder.executeTimeout);
        }
        if (builder.closeTimeoutIsSet()) {
            this.initShim.closeTimeout(builder.closeTimeout);
        }
        this.delegateToBatch = this.initShim.delegateToBatch();
        this.mixinStacktrace = this.initShim.mixinStacktrace();
        this.executeTimeout = this.initShim.executeTimeout();
        this.closeTimeout = this.initShim.closeTimeout();
        this.initShim = null;
    }

    @Override
    public Optional<String> authenticationTypeAndValue() {
        return Optional.ofNullable(this.authenticationTypeAndValue);
    }

    @Override
    public Optional<ScheduledExecutorService> scheduler() {
        return Optional.ofNullable(this.scheduler);
    }

    @Override
    public boolean delegateToBatch() {
        InitShim shim = this.initShim;
        return shim != null ? shim.delegateToBatch() : this.delegateToBatch;
    }

    @Override
    public boolean mixinStacktrace() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mixinStacktrace() : this.mixinStacktrace;
    }

    @Override
    public Duration executeTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.executeTimeout() : this.executeTimeout;
    }

    @Override
    public Duration closeTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.closeTimeout() : this.closeTimeout;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSessionConfig && this.equalsByValue((ImmutableSessionConfig)another);
    }

    private boolean equalsByValue(ImmutableSessionConfig another) {
        return Objects.equals(this.authenticationTypeAndValue, another.authenticationTypeAndValue) && Objects.equals(this.scheduler, another.scheduler) && this.delegateToBatch == another.delegateToBatch && this.mixinStacktrace == another.mixinStacktrace && this.executeTimeout.equals(another.executeTimeout) && this.closeTimeout.equals(another.closeTimeout);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + Objects.hashCode(this.authenticationTypeAndValue);
        h += (h << 5) + Objects.hashCode(this.scheduler);
        h += (h << 5) + Boolean.hashCode(this.delegateToBatch);
        h += (h << 5) + Boolean.hashCode(this.mixinStacktrace);
        h += (h << 5) + this.executeTimeout.hashCode();
        h += (h << 5) + this.closeTimeout.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SessionConfig{");
        if (this.scheduler != null) {
            if (builder.length() > 14) {
                builder.append(", ");
            }
            builder.append("scheduler=").append(this.scheduler);
        }
        if (builder.length() > 14) {
            builder.append(", ");
        }
        builder.append("delegateToBatch=").append(this.delegateToBatch);
        builder.append(", ");
        builder.append("mixinStacktrace=").append(this.mixinStacktrace);
        builder.append(", ");
        builder.append("executeTimeout=").append(this.executeTimeout);
        builder.append(", ");
        builder.append("closeTimeout=").append(this.closeTimeout);
        return builder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SessionConfig", generator="Immutables")
    private final class InitShim {
        private byte delegateToBatchBuildStage = 0;
        private boolean delegateToBatch;
        private byte mixinStacktraceBuildStage = 0;
        private boolean mixinStacktrace;
        private byte executeTimeoutBuildStage = 0;
        private Duration executeTimeout;
        private byte closeTimeoutBuildStage = 0;
        private Duration closeTimeout;

        private InitShim() {
        }

        boolean delegateToBatch() {
            if (this.delegateToBatchBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.delegateToBatchBuildStage == 0) {
                boolean computedValue;
                this.delegateToBatchBuildStage = (byte)-1;
                this.delegateToBatch = computedValue = ImmutableSessionConfig.super.delegateToBatch();
                this.delegateToBatchBuildStage = 1;
            }
            return this.delegateToBatch;
        }

        void delegateToBatch(boolean delegateToBatch) {
            this.delegateToBatch = delegateToBatch;
            this.delegateToBatchBuildStage = 1;
        }

        boolean mixinStacktrace() {
            if (this.mixinStacktraceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mixinStacktraceBuildStage == 0) {
                boolean computedValue;
                this.mixinStacktraceBuildStage = (byte)-1;
                this.mixinStacktrace = computedValue = ImmutableSessionConfig.super.mixinStacktrace();
                this.mixinStacktraceBuildStage = 1;
            }
            return this.mixinStacktrace;
        }

        void mixinStacktrace(boolean mixinStacktrace) {
            this.mixinStacktrace = mixinStacktrace;
            this.mixinStacktraceBuildStage = 1;
        }

        Duration executeTimeout() {
            if (this.executeTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.executeTimeoutBuildStage == 0) {
                this.executeTimeoutBuildStage = (byte)-1;
                Duration computedValue = ImmutableSessionConfig.super.executeTimeout();
                this.executeTimeout = Objects.requireNonNull(computedValue, "executeTimeout");
                this.executeTimeoutBuildStage = 1;
            }
            return this.executeTimeout;
        }

        void executeTimeout(Duration executeTimeout) {
            this.executeTimeout = executeTimeout;
            this.executeTimeoutBuildStage = 1;
        }

        Duration closeTimeout() {
            if (this.closeTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.closeTimeoutBuildStage == 0) {
                this.closeTimeoutBuildStage = (byte)-1;
                Duration computedValue = ImmutableSessionConfig.super.closeTimeout();
                this.closeTimeout = Objects.requireNonNull(computedValue, "closeTimeout");
                this.closeTimeoutBuildStage = 1;
            }
            return this.closeTimeout;
        }

        void closeTimeout(Duration closeTimeout) {
            this.closeTimeout = closeTimeout;
            this.closeTimeoutBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.delegateToBatchBuildStage == -1) {
                attributes.add("delegateToBatch");
            }
            if (this.mixinStacktraceBuildStage == -1) {
                attributes.add("mixinStacktrace");
            }
            if (this.executeTimeoutBuildStage == -1) {
                attributes.add("executeTimeout");
            }
            if (this.closeTimeoutBuildStage == -1) {
                attributes.add("closeTimeout");
            }
            return "Cannot build SessionConfig, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="SessionConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements SessionConfig.Builder {
        private static final long OPT_BIT_AUTHENTICATION_TYPE_AND_VALUE = 1L;
        private static final long OPT_BIT_SCHEDULER = 2L;
        private static final long OPT_BIT_DELEGATE_TO_BATCH = 4L;
        private static final long OPT_BIT_MIXIN_STACKTRACE = 8L;
        private static final long OPT_BIT_EXECUTE_TIMEOUT = 16L;
        private static final long OPT_BIT_CLOSE_TIMEOUT = 32L;
        private long optBits;
        @Nullable
        private String authenticationTypeAndValue;
        @Nullable
        private ScheduledExecutorService scheduler;
        private boolean delegateToBatch;
        private boolean mixinStacktrace;
        @Nullable
        private Duration executeTimeout;
        @Nullable
        private Duration closeTimeout;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder authenticationTypeAndValue(String authenticationTypeAndValue) {
            Builder.checkNotIsSet(this.authenticationTypeAndValueIsSet(), "authenticationTypeAndValue");
            this.authenticationTypeAndValue = Objects.requireNonNull(authenticationTypeAndValue, "authenticationTypeAndValue");
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authenticationTypeAndValue(Optional<String> authenticationTypeAndValue) {
            Builder.checkNotIsSet(this.authenticationTypeAndValueIsSet(), "authenticationTypeAndValue");
            this.authenticationTypeAndValue = authenticationTypeAndValue.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder scheduler(ScheduledExecutorService scheduler) {
            Builder.checkNotIsSet(this.schedulerIsSet(), "scheduler");
            this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder scheduler(Optional<? extends ScheduledExecutorService> scheduler) {
            Builder.checkNotIsSet(this.schedulerIsSet(), "scheduler");
            this.scheduler = scheduler.orElse(null);
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder delegateToBatch(boolean delegateToBatch) {
            Builder.checkNotIsSet(this.delegateToBatchIsSet(), "delegateToBatch");
            this.delegateToBatch = delegateToBatch;
            this.optBits |= 4L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder mixinStacktrace(boolean mixinStacktrace) {
            Builder.checkNotIsSet(this.mixinStacktraceIsSet(), "mixinStacktrace");
            this.mixinStacktrace = mixinStacktrace;
            this.optBits |= 8L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder executeTimeout(Duration executeTimeout) {
            Builder.checkNotIsSet(this.executeTimeoutIsSet(), "executeTimeout");
            this.executeTimeout = Objects.requireNonNull(executeTimeout, "executeTimeout");
            this.optBits |= 0x10L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder closeTimeout(Duration closeTimeout) {
            Builder.checkNotIsSet(this.closeTimeoutIsSet(), "closeTimeout");
            this.closeTimeout = Objects.requireNonNull(closeTimeout, "closeTimeout");
            this.optBits |= 0x20L;
            return this;
        }

        @Override
        public ImmutableSessionConfig build() {
            return new ImmutableSessionConfig(this);
        }

        private boolean authenticationTypeAndValueIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean schedulerIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean delegateToBatchIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean mixinStacktraceIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean executeTimeoutIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean closeTimeoutIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of SessionConfig is strict, attribute is already set: ".concat(name));
            }
        }
    }
}

