/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.HasPathId;
import io.deephaven.client.impl.HasTicketId;
import io.deephaven.client.impl.PathId;
import io.deephaven.client.impl.TicketId;
import io.deephaven.proto.util.ByteHelper;
import io.deephaven.proto.util.SharedTicketHelper;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;

public class SharedId
implements HasTicketId,
HasPathId {
    private final byte[] sharedId;

    public static SharedId newRandom() {
        ByteBuffer sharedId = ByteBuffer.allocate(16);
        UUID uuid = UUID.randomUUID();
        sharedId.putLong(uuid.getMostSignificantBits());
        sharedId.putLong(uuid.getLeastSignificantBits());
        return new SharedId(sharedId.array());
    }

    public SharedId(byte[] sharedId) {
        this.sharedId = Objects.requireNonNull(sharedId);
    }

    @Override
    public TicketId ticketId() {
        return new TicketId(SharedTicketHelper.idToBytes((byte[])this.sharedId));
    }

    @Override
    public PathId pathId() {
        return new PathId(SharedTicketHelper.idToPath((byte[])this.sharedId));
    }

    public String asHexString() {
        return "0x" + ByteHelper.byteBufToHex((ByteBuffer)ByteBuffer.wrap(this.sharedId));
    }
}

