/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.Export;
import io.deephaven.client.impl.ExportRequest;
import io.deephaven.client.impl.ExportService;
import io.deephaven.client.impl.ExportServiceRequest;
import io.deephaven.client.impl.ExportsRequest;
import io.deephaven.client.impl.TableHandle;
import io.deephaven.client.impl.TableService;
import io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse;
import io.deephaven.qst.table.TableSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

final class TableServiceAsyncImpl {
    TableServiceAsyncImpl() {
    }

    static TableService.TableHandleFuture executeAsync(ExportService exportService, TableSpec tableSpec) {
        TableHandleAsyncImpl impl = new TableHandleAsyncImpl(tableSpec);
        ExportRequest request = ExportRequest.of(tableSpec, impl);
        try (ExportServiceRequest esr = exportService.exportRequest(ExportsRequest.of(request));){
            List<Export> exports = esr.exports();
            if (exports.size() != 1) {
                throw new IllegalStateException();
            }
            impl.init(exports.get(0));
            esr.send();
        }
        return impl;
    }

    static List<? extends TableService.TableHandleFuture> executeAsync(ExportService exportService, Iterable<? extends TableSpec> tableSpecs) {
        ArrayList<TableHandleAsyncImpl> impls = new ArrayList<TableHandleAsyncImpl>();
        ExportsRequest.Builder builder = ExportsRequest.builder();
        for (TableSpec tableSpec : tableSpecs) {
            TableHandleAsyncImpl impl = new TableHandleAsyncImpl(tableSpec);
            builder.addRequests(ExportRequest.of(tableSpec, impl));
            impls.add(impl);
        }
        int size = impls.size();
        try (ExportServiceRequest exportServiceRequest = exportService.exportRequest(builder.build());){
            List<Export> exports = exportServiceRequest.exports();
            if (exports.size() != size) {
                throw new IllegalStateException();
            }
            for (int i = 0; i < size; ++i) {
                ((TableHandleAsyncImpl)impls.get(i)).init(exports.get(i));
            }
            exportServiceRequest.send();
        }
        return impls;
    }

    private static class TableHandleAsyncImpl
    implements TableService.TableHandleFuture,
    ExportRequest.Listener {
        private final TableSpec tableSpec;
        private final CompletableFuture<Export> exportFuture;
        private final CompletableFuture<ExportedTableCreationResponse> etcrFuture;
        private final CompletableFuture<TableHandle> future;

        TableHandleAsyncImpl(TableSpec tableSpec) {
            this.tableSpec = Objects.requireNonNull(tableSpec);
            this.exportFuture = new CompletableFuture();
            this.etcrFuture = new CompletableFuture();
            CompletionStage internalFuture = CompletableFuture.allOf(this.exportFuture, this.etcrFuture).thenCompose(this::complete);
            this.future = ((CompletableFuture)internalFuture).thenApply(Function.identity());
            this.future.whenComplete((arg_0, arg_1) -> TableHandleAsyncImpl.lambda$new$0((CompletableFuture)internalFuture, arg_0, arg_1));
        }

        void init(Export export) {
            this.exportFuture.complete(Objects.requireNonNull(export));
        }

        private CompletionStage<TableHandle> complete(Void ignore) {
            Export export = Objects.requireNonNull(this.exportFuture.getNow(null));
            ExportedTableCreationResponse etcr = Objects.requireNonNull(this.etcrFuture.getNow(null));
            TableHandle tableHandle = new TableHandle(this.tableSpec, null);
            tableHandle.init(export);
            TableHandle.ResponseAdapter responseAdapter = tableHandle.responseAdapter();
            responseAdapter.onNext(etcr);
            responseAdapter.onCompleted();
            TableHandle.TableHandleException error = tableHandle.error().orElse(null);
            if (error != null) {
                CompletableFuture<TableHandle> f = new CompletableFuture<TableHandle>();
                f.completeExceptionally(error);
                return f;
            }
            return CompletableFuture.completedFuture(tableHandle);
        }

        @Override
        public void onNext(ExportedTableCreationResponse etcr) {
            this.etcrFuture.complete(etcr);
        }

        @Override
        public void onError(Throwable t) {
            this.etcrFuture.completeExceptionally(t);
        }

        @Override
        public void onCompleted() {
            if (!this.etcrFuture.isDone()) {
                this.etcrFuture.completeExceptionally(new IllegalStateException("onCompleted without etcrFuture.isDone()"));
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public TableHandle get() throws InterruptedException, ExecutionException {
            return this.future.get();
        }

        @Override
        public TableHandle get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.future.get(timeout, unit);
        }

        private static /* synthetic */ void lambda$new$0(CompletableFuture internalFuture, TableHandle tableHandle, Throwable throwable) {
            if (throwable instanceof CancellationException) {
                internalFuture.thenAccept(TableHandle::close);
            }
        }
    }
}

