/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class UnaryGrpcFuture<ReqT, RespT, V>
implements ClientResponseObserver<ReqT, RespT> {
    private final CompletableFuture<V> future = new CompletableFuture();
    private final Function<RespT, V> mapping;

    public static <ReqT, RespT, V> CompletableFuture<V> of(ReqT request, BiConsumer<ReqT, StreamObserver<RespT>> call, Function<RespT, V> mapping) {
        UnaryGrpcFuture<ReqT, RespT, V> observer = new UnaryGrpcFuture<ReqT, RespT, V>(mapping);
        call.accept(request, (StreamObserver<RespT>)observer);
        return observer.future();
    }

    public static <ReqT, RespT> CompletableFuture<Void> ignoreResponse(ReqT request, BiConsumer<ReqT, StreamObserver<RespT>> call) {
        return UnaryGrpcFuture.of(request, call, ignore -> null);
    }

    private UnaryGrpcFuture(Function<RespT, V> mapping) {
        this.mapping = mapping;
    }

    public CompletableFuture<V> future() {
        return this.future;
    }

    public void beforeStart(ClientCallStreamObserver<ReqT> requestStream) {
        this.future.whenComplete((session, throwable) -> {
            if (this.future.isCancelled()) {
                requestStream.cancel("User cancelled", null);
            }
        });
    }

    public void onNext(RespT value) {
        this.future.complete(this.mapping.apply(value));
    }

    public void onError(Throwable t) {
        this.future.completeExceptionally(t);
    }

    public void onCompleted() {
        if (!this.future.isDone()) {
            this.future.completeExceptionally(new IllegalStateException("Observer completed without response"));
        }
    }
}

