/*
 * Decompiled with CFR 0.152.
 */
package io.divide.client;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.divide.client.BackendModule;
import io.divide.client.Config;
import io.divide.client.auth.AuthManager;
import io.divide.client.data.DataManager;
import io.divide.shared.logging.Logger;

public class Backend {
    private static Logger logger = Logger.getLogger(Backend.class);
    private static boolean initialized = false;
    @Inject
    private static Injector injector;
    @Inject
    private Config config;
    @Inject
    private AuthManager authManager;
    @Inject
    private DataManager dataManager;

    @Inject
    protected Backend() {
        initialized = true;
    }

    public AuthManager getAuthManager() {
        return this.authManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public Config getConfig() {
        return this.config;
    }

    public static void inject(Object o) {
        if (!initialized) {
            throw new RuntimeException("Backend must be initialized!");
        }
        injector.injectMembers(o);
    }

    public static synchronized <BackendType extends Backend> BackendType init(Config<BackendType> config) {
        logger.debug((Object)("Initializing... " + config));
        Guice.createInjector((Module[])new Module[]{config.getModule()});
        return (BackendType)((Backend)injector.getInstance(config.getModuleType()));
    }

    protected Injector getInjector(BackendModule module) {
        return Guice.createInjector((Module[])new Module[]{module});
    }
}

