/*
 * Decompiled with CFR 0.152.
 */
package io.divide.client;

import io.divide.client.BackendObject;
import io.divide.client.auth.AuthManager;
import io.divide.client.auth.LoginListener;
import io.divide.client.data.ObjectManager;
import io.divide.shared.server.DAO;
import javax.inject.Inject;

public class BackendServices {
    @Inject
    private static AuthManager authManager;
    @Inject
    private static ObjectManager objectManager;

    private BackendServices() {
    }

    public static ObjectManager.RemoteStorage remote() {
        BackendServices.checkIsInitialized(objectManager);
        return objectManager.remote();
    }

    public static DAO<BackendObject, BackendObject> local() {
        BackendServices.checkIsInitialized(objectManager);
        return objectManager.local();
    }

    public static void addLoginListener(LoginListener loginListener) {
        BackendServices.checkIsInitialized(authManager);
        authManager.addLoginListener(loginListener);
    }

    private static void checkIsInitialized(Object o) {
        if (o == null) {
            throw new RuntimeException("Backend not initialized!");
        }
    }
}

