/*
 * Decompiled with CFR 0.152.
 */
package io.divide.client.auth;

import com.google.inject.Inject;
import io.divide.client.BackendUser;
import io.divide.client.Config;
import io.divide.client.auth.AccountStorage;
import io.divide.client.auth.AuthWebService;
import io.divide.client.auth.LoginListener;
import io.divide.client.auth.LoginState;
import io.divide.client.auth.SignInResponse;
import io.divide.client.auth.SignUpResponse;
import io.divide.client.auth.credentials.LocalCredentials;
import io.divide.client.auth.credentials.LoginCredentials;
import io.divide.client.auth.credentials.SignUpCredentials;
import io.divide.client.auth.credentials.ValidCredentials;
import io.divide.client.data.ServerResponse;
import io.divide.client.http.Status;
import io.divide.client.web.AbstractWebManager;
import io.divide.shared.logging.Logger;
import io.divide.shared.transitory.Credentials;
import io.divide.shared.util.Crypto;
import io.divide.shared.util.ObjectUtils;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.schedulers.Schedulers;
import rx.subjects.PublishSubject;

public class AuthManager
extends AbstractWebManager<AuthWebService> {
    private static Logger logger = Logger.getLogger(AuthManager.class);
    private BackendUser user;
    private AccountStorage accountStorage;
    private LoginState CURRENT_STATE = LoginState.LOGGED_OUT;
    private PublishSubject<BackendUser> loginEventPublisher = PublishSubject.create();
    private static PublicKey serverPublicKey = null;

    @Inject
    public AuthManager(Config config, AccountStorage accountStorage) {
        super(config);
        this.accountStorage = accountStorage;
        this.loadCachedUser().subscribeOn(Schedulers.io()).subscribe((Action1)new Action1<BackendUser>(){

            public void call(BackendUser user) {
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                logger.error((Object)"Failed to login", throwable);
            }
        });
    }

    private Observable<BackendUser> loadCachedUser() {
        logger.debug((Object)("Stored user Login: " + this.getStoredAccount()));
        if (this.getUser() != null) {
            return Observable.from((Object)((Object)this.getUser()));
        }
        if (this.getStoredAccount() != null) {
            logger.debug((Object)("Stored user Login: " + this.getStoredAccount()));
            return this.guardedLogin(this.getStoredAccount());
        }
        return Observable.empty();
    }

    public LocalCredentials getStoredAccount() {
        return (LocalCredentials)ObjectUtils.get1stOrNull(this.accountStorage.getAccounts());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Observable<BackendUser> guardedLogin(LocalCredentials account) {
        Class<AuthManager> clazz = AuthManager.class;
        synchronized (AuthManager.class) {
            switch (this.CURRENT_STATE) {
                case LOGGED_IN: {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return Observable.from((Object)((Object)this.getUser()));
                }
                case LOGGING_IN: {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.loginEventPublisher.asObservable();
                }
                case LOGGED_OUT: {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.getUserFromAuthToken(account.getAuthToken());
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Observable.error((Throwable)new Exception("Invalid current State?!: " + (Object)((Object)this.CURRENT_STATE)));
        }
    }

    public Observable<BackendUser> getUserFromAuthToken(final String authToken) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<BackendUser>(){

            public void call(Subscriber<? super BackendUser> subscriber) {
                try {
                    AuthManager.this.setLoginState(LoginState.LOGGING_IN);
                    logger.debug((Object)("getWebService(): " + AuthManager.this.getWebService()));
                    logger.debug((Object)("getuserFromAuthToken: " + authToken));
                    ValidCredentials validCredentials = (ValidCredentials)((Object)((AuthWebService)AuthManager.this.getWebService()).getUserFromAuthToken(authToken).toBlocking().first());
                    if (validCredentials == null) {
                        throw new Exception("Null User Returned");
                    }
                    subscriber.onNext((Object)AuthManager.this.setUser(validCredentials));
                }
                catch (Exception e) {
                    AuthManager.this.setLoginState(LoginState.LOGGED_OUT);
                    subscriber.onError((Throwable)e);
                }
            }
        });
    }

    public Observable<BackendUser> getUserFromRecoveryToken(final String recoveryToken) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<BackendUser>(){

            public void call(Subscriber<? super BackendUser> subscriber) {
                try {
                    AuthManager.this.setLoginState(LoginState.LOGGING_IN);
                    ValidCredentials validCredentials = (ValidCredentials)((Object)((AuthWebService)AuthManager.this.getWebService()).getUserFromRecoveryToken(recoveryToken).toBlockingObservable().first());
                    if (validCredentials == null) {
                        throw new Exception("Null User Returned");
                    }
                    subscriber.onNext((Object)AuthManager.this.setUser(validCredentials));
                }
                catch (Exception e) {
                    AuthManager.this.setLoginState(LoginState.LOGGED_OUT);
                    subscriber.onError((Throwable)e);
                }
            }
        });
    }

    public BackendUser getUser() {
        return this.user;
    }

    public void logout() {
        List<LocalCredentials> accountList = this.accountStorage.getAccounts();
        if (accountList.size() == 1) {
            String userName = accountList.get(0).getName();
            logger.debug((Object)("logout: " + userName));
            this.accountStorage.removeAccount(userName);
            this.user = null;
        }
        this.setLoginState(LoginState.LOGGED_OUT);
    }

    private BackendUser setUser(ValidCredentials returned) {
        logger.debug((Object)("setUser: " + (Object)((Object)returned)));
        this.user = BackendUser.from(returned);
        logger.debug((Object)("setUser: " + (Object)((Object)this.getUser())));
        if (returned != null) {
            this.storeOrUpdateAccount(returned);
        }
        this.fireLoginListeners();
        this.setLoginState(LoginState.LOGGED_IN);
        return this.getUser();
    }

    private void storeOrUpdateAccount(Credentials validCredentials) {
        logger.debug((Object)("storeOrUpdateAccount: " + validCredentials));
        String accountName = validCredentials.getEmailAddress();
        String recoveryToken = validCredentials.getRecoveryToken();
        String authToken = validCredentials.getAuthToken();
        if (!this.accountStorage.exists(accountName)) {
            LocalCredentials account = new LocalCredentials();
            account.setName(accountName);
            account.setAuthToken(authToken);
            account.setRecoveryToken(recoveryToken);
            this.accountStorage.addAcccount(account);
        } else {
            this.accountStorage.setAuthToken(accountName, authToken);
            if (recoveryToken != null && recoveryToken.length() > 0) {
                this.accountStorage.setRecoveryToken(accountName, recoveryToken);
            }
        }
    }

    public PublicKey getServerKey() {
        logger.debug((Object)"getServerKey()");
        try {
            if (serverPublicKey != null) {
                return serverPublicKey;
            }
            byte[] pubKey = ((AuthWebService)this.getWebService()).getPublicKey();
            logger.debug((Object)("pubKey: " + String.valueOf(pubKey)));
            serverPublicKey = Crypto.pubKeyFromBytes((byte[])pubKey);
            return serverPublicKey;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to getServerKey()", (Throwable)e);
            return null;
        }
    }

    public SignUpResponse signUp(SignUpCredentials loginCreds) {
        logger.debug((Object)("signUp(" + (Object)((Object)loginCreds) + ")"));
        try {
            this.setLoginState(LoginState.LOGGING_IN);
            PublicKey key = Crypto.pubKeyFromBytes((byte[])((AuthWebService)this.getWebService()).getPublicKey());
            loginCreds.encryptPassword(key);
            logger.debug((Object)("Login Creds: " + (Object)((Object)loginCreds)));
            ServerResponse<ValidCredentials> response = ServerResponse.from(ValidCredentials.class, ((AuthWebService)this.getWebService()).userSignUp(loginCreds));
            logger.debug((Object)("Response: " + response.getStatus()));
            if (!response.getStatus().isSuccess()) {
                return new SignUpResponse(null, Status.SERVER_ERROR_INTERNAL, " null user returned");
            }
            BackendUser user = this.setUser(response.get());
            return new SignUpResponse(user, response.getStatus(), response.getError());
        }
        catch (Exception e) {
            logger.error((Object)("SignUp Failure(" + loginCreds.getEmailAddress() + ")"), (Throwable)e);
            return new SignUpResponse(null, Status.SERVER_ERROR_INTERNAL, e.getLocalizedMessage());
        }
    }

    public Observable<BackendUser> signUpASync(final SignUpCredentials signInCreds) {
        logger.debug((Object)("signUpASync(" + (Object)((Object)signInCreds) + ")"));
        try {
            this.setLoginState(LoginState.LOGGING_IN);
            return ((AuthWebService)this.getWebService()).getPublicKeyA().flatMap((Func1)new Func1<byte[], Observable<SignUpCredentials>>(){

                public Observable<SignUpCredentials> call(byte[] bytes) {
                    try {
                        PublicKey key = Crypto.pubKeyFromBytes((byte[])bytes);
                        signInCreds.encryptPassword(key);
                        return Observable.from((Object)((Object)signInCreds));
                    }
                    catch (Exception e) {
                        return Observable.error((Throwable)e);
                    }
                }
            }).flatMap((Func1)new Func1<SignUpCredentials, Observable<ValidCredentials>>(){

                public Observable<ValidCredentials> call(SignUpCredentials o) {
                    return ((AuthWebService)AuthManager.this.getWebService()).userSignUpA(signInCreds);
                }
            }).map((Func1)new Func1<ValidCredentials, BackendUser>(){

                public BackendUser call(ValidCredentials validCredentials) {
                    return AuthManager.this.setUser(validCredentials);
                }
            }).subscribeOn(Schedulers.io()).observeOn(this.config.observeOn());
        }
        catch (Exception e) {
            logger.error((Object)("Failed to signUp(" + signInCreds.getEmailAddress() + ")"), (Throwable)e);
            return Observable.error((Throwable)e);
        }
    }

    public SignInResponse login(LoginCredentials loginCreds) {
        logger.debug((Object)("login(" + (Object)((Object)loginCreds) + ")"));
        try {
            this.setLoginState(LoginState.LOGGING_IN);
            if (!loginCreds.isEncrypted()) {
                PublicKey key = Crypto.pubKeyFromBytes((byte[])((AuthWebService)this.getWebService()).getPublicKey());
                loginCreds.encryptPassword(key);
            }
            logger.debug((Object)("Login Creds: " + (Object)((Object)loginCreds)));
            ServerResponse<ValidCredentials> response = ServerResponse.from(ValidCredentials.class, ((AuthWebService)this.getWebService()).login(loginCreds));
            if (!response.getStatus().isSuccess()) {
                logger.error((Object)("Login Failure(" + loginCreds.getEmailAddress() + "): " + response.getStatus().getCode() + " " + response.getError()));
                this.setLoginState(LoginState.LOGGED_OUT);
                return new SignInResponse(null, Status.SERVER_ERROR_INTERNAL, "Login failed");
            }
            BackendUser user = this.setUser(response.get());
            return new SignInResponse(user, response.getStatus(), response.getError());
        }
        catch (Exception e) {
            logger.error((Object)("Login Failure(" + loginCreds.getEmailAddress() + ")"), (Throwable)e);
            this.setLoginState(LoginState.LOGGED_OUT);
            return new SignInResponse(null, Status.SERVER_ERROR_INTERNAL, e.getLocalizedMessage());
        }
    }

    public Observable<BackendUser> loginASync(final LoginCredentials loginCreds) {
        logger.debug((Object)("loginASync(" + (Object)((Object)loginCreds) + ")"));
        try {
            this.setLoginState(LoginState.LOGGING_IN);
            return ((AuthWebService)this.getWebService()).getPublicKeyA().flatMap((Func1)new Func1<byte[], Observable<LoginCredentials>>(){

                public Observable<LoginCredentials> call(byte[] bytes) {
                    try {
                        if (!loginCreds.isEncrypted()) {
                            PublicKey key = Crypto.pubKeyFromBytes((byte[])bytes);
                            loginCreds.encryptPassword(key);
                        }
                        return Observable.from((Object)((Object)loginCreds));
                    }
                    catch (Exception e) {
                        return Observable.error((Throwable)e);
                    }
                }
            }).flatMap((Func1)new Func1<LoginCredentials, Observable<ValidCredentials>>(){

                public Observable<ValidCredentials> call(LoginCredentials credentials) {
                    return ((AuthWebService)AuthManager.this.getWebService()).loginA(credentials);
                }
            }).map((Func1)new Func1<ValidCredentials, BackendUser>(){

                public BackendUser call(ValidCredentials validCredentials) {
                    return AuthManager.this.setUser(validCredentials);
                }
            }).subscribeOn(Schedulers.io()).observeOn(this.config.observeOn());
        }
        catch (Exception e) {
            logger.error((Object)("Failed to SignIn(" + loginCreds.getEmailAddress() + ")"), (Throwable)e);
            this.setLoginState(LoginState.LOGGED_OUT);
            return Observable.error((Throwable)e);
        }
    }

    private void setLoginState(@NotNull LoginState state) {
        logger.debug((Object)("Changing State(" + this.config.id + "): " + (Object)((Object)state)));
        this.CURRENT_STATE = state;
    }

    public Observable<Void> sendUserData(BackendUser backendUser) {
        return ((AuthWebService)this.getWebService()).sendUserData(this.isLoggedIn(), backendUser.getOwnerId() + "", backendUser.getUserData()).subscribeOn(this.config.subscribeOn()).observeOn(this.config.observeOn());
    }

    public Observable<Map<String, Object>> getUserData(BackendUser backendUser) {
        return ((AuthWebService)this.getWebService()).getUserData(this.isLoggedIn(), backendUser.getOwnerId() + "").subscribeOn(this.config.subscribeOn()).observeOn(this.config.observeOn());
    }

    @Override
    protected Class<AuthWebService> getType() {
        return AuthWebService.class;
    }

    public void addLoginListener(LoginListener listener) {
        logger.debug((Object)"addLoginListener");
        Subscription subscription = this.loginEventPublisher.subscribeOn(this.config.subscribeOn()).observeOn(this.config.observeOn()).subscribe((Observer)listener);
        listener.setSubscription(subscription);
    }

    private void fireLoginListeners() {
        logger.debug((Object)("fireLoginListeners: " + (Object)((Object)this.getUser())));
        this.loginEventPublisher.onNext((Object)this.getUser());
    }

    private String isLoggedIn() throws RuntimeException {
        if (this.getUser() != null && this.getUser().getAuthToken() != null) {
            return "CUSTOM " + this.getUser().getAuthToken();
        }
        throw new RuntimeException("User state error.");
    }
}

