/*
 * Decompiled with CFR 0.152.
 */
package io.divide.client.cache;

import com.google.inject.Inject;
import iBoxDB.LocalServer.AutoBox;
import iBoxDB.LocalServer.DB;
import iBoxDB.LocalServer.E.CommitExpection;
import iBoxDB.LocalServer.IFunction;
import io.divide.client.Config;
import io.divide.client.cache.Wrapper;
import io.divide.shared.server.DAO;
import io.divide.shared.transitory.TransientObject;
import io.divide.shared.transitory.query.Clause;
import io.divide.shared.transitory.query.OPERAND;
import io.divide.shared.transitory.query.Query;
import io.divide.shared.util.ObjectUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LocalStorageIBoxDb<T1 extends TransientObject, T2 extends TransientObject>
implements DAO<T1, T2> {
    DB db;
    AutoBox box;

    @Inject
    public LocalStorageIBoxDb(Config config) {
        this(config.fileSavePath + "dbs");
    }

    public LocalStorageIBoxDb(String path) {
        System.out.println("iBox: " + path);
        File f = new File(path);
        f.mkdirs();
        this.db = new DB(path);
        this.db.ensureTable(Wrapper.class, "Wrapper", new String[]{"Key", "Table"});
        this.box = this.db.open();
    }

    public void save(T1 ... objects) throws DAO.DAOException {
        for (T1 b : objects) {
            try {
                boolean exists = this.exists(new TransientObject[]{b});
                System.out.println("Exists: " + exists);
                if (exists) {
                    System.out.println("update: " + b.getObjectKey());
                    this.box.update("Wrapper", (Object)new Wrapper(b));
                    continue;
                }
                System.out.println("insert: " + b.getObjectKey());
                this.box.insert("Wrapper", (Object)new Wrapper(b));
            }
            catch (CommitExpection e) {
                e.printStackTrace();
                throw new DAO.DAOException((Throwable)e);
            }
        }
    }

    public void delete(T1 ... objects) throws DAO.DAOException {
        String[] keys = new String[objects.length];
        for (int x = 0; x < objects.length; ++x) {
            keys[x] = objects[x].getObjectKey();
        }
        Iterable<Wrapper> x = this.internalGet(objects[0].getObjectType(), keys);
        for (Wrapper wr : x) {
            this.box.delete("Wrapper", (Object)wr);
        }
    }

    public boolean exists(TransientObject ... objects) {
        if (objects.length == 0) {
            return false;
        }
        boolean found = true;
        for (TransientObject o : objects) {
            Wrapper o1 = (Wrapper)iBoxUtils.GetFrist(this.box.select(Wrapper.class, "from Wrapper where Key==? && Table==?", new Object[]{o.getObjectKey(), o.getObjectType()}));
            if (o1 != null) continue;
            found = false;
        }
        return found;
    }

    public int count(String type) {
        return (int)this.box.selectCount("from Wrapper where Table==?", new Object[]{type});
    }

    public <B extends T2> List<B> query(Query query) {
        Class<?> type = null;
        try {
            type = Class.forName(Query.reverseTable((String)query.getFrom()));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        String table = query.getFrom();
        Map where = query.getWhere();
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(table);
        StringBuilder sb = new StringBuilder();
        sb.append("from Wrapper where Table==? ");
        if (where.size() > 0) {
            sb.append("&& (");
            for (Clause c : where.values()) {
                if (c.getPreOperator() != null && c.getPreOperator().length() != 0) {
                    OPERAND.Conditional con = OPERAND.Conditional.from((String)c.getPreOperator());
                    String conString = "";
                    switch (con) {
                        case AND: {
                            conString = "||";
                            break;
                        }
                        case OR: {
                            conString = "&&";
                        }
                    }
                    sb.append(" ").append(conString).append(" [").append(c.getBefore()).append("]");
                } else {
                    sb.append(" [").append(c.getBefore()).append("]");
                }
                args.add(new QueryArray(c.getOperand(), c.getAfter()));
            }
            sb.append(')');
        }
        if (query.getLimit() != null) {
            sb.append(" limit 0," + query.getLimit());
        }
        Iterable list = this.box.select(Wrapper.class, sb.toString(), args.toArray());
        ArrayList bList = new ArrayList();
        for (Wrapper w : list) {
            bList.add(w.toObject(type));
        }
        return bList;
    }

    public <O extends T2> Collection<O> get(String type, String ... keys) throws DAO.DAOException {
        System.out.println("get(" + type + "): " + ObjectUtils.v2c((Object[])keys));
        Class<?> clazz = null;
        try {
            clazz = Class.forName(Query.reverseTable((String)type));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        ArrayList list = new ArrayList();
        for (Wrapper w : this.internalGet(type, keys)) {
            list.add(w.toObject(clazz));
        }
        return list;
    }

    private Iterable<Wrapper> internalGet(String type, String ... keys) {
        StringBuilder query = new StringBuilder();
        query.append("from Wrapper where Table==? && (");
        ArrayList<String> args = new ArrayList<String>();
        args.add(type);
        for (int x = 0; x < keys.length; ++x) {
            args.add(keys[x]);
            query.append("Key==?");
            if (x >= keys.length - 1) continue;
            query.append(" || ");
        }
        query.append(')');
        Iterable x = this.box.select(Wrapper.class, query.toString(), args.toArray());
        return x;
    }

    public static class QueryArray
    implements IFunction {
        private OPERAND operand;
        private String match;

        public QueryArray(String operand, String match) {
            this.operand = OPERAND.from((String)operand);
            this.match = match;
        }

        public Object execute(int argCount, Object[] args) {
            Object[] tags;
            if (this.compare(args[0])) {
                return true;
            }
            if (!ObjectUtils.isArray((Object)args[0])) {
                return false;
            }
            if (args[0] == null) {
                return false;
            }
            for (Object t : tags = (Object[])args[0]) {
                if (!this.compare(t)) continue;
                return true;
            }
            return false;
        }

        private boolean compare(Object one) {
            int result = this.match.compareToIgnoreCase(String.valueOf(one));
            switch (this.operand) {
                case CONTAINS: 
                case EQ: {
                    return result == 0;
                }
                case GREATER_THAN: {
                    return result < 0;
                }
                case GREATER_THAN_EQ: {
                    return result < 0 || result == 0;
                }
                case LESS_THAN: {
                    return result > 0;
                }
                case LESS_THAN_EQ: {
                    return result > 0 || result == 0;
                }
            }
            return false;
        }

        public String toString() {
            return "QueryArray{match" + this.operand + this.match + '\'' + '}';
        }
    }

    public static class iBoxUtils {
        public static <T> T GetFrist(Iterable<T> list) {
            Iterator<T> i$ = list.iterator();
            if (i$.hasNext()) {
                T o = i$.next();
                return o;
            }
            return null;
        }
    }
}

