/*
 * Decompiled with CFR 0.152.
 */
package io.divide.client.cache;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.divide.shared.transitory.TransientObject;
import io.divide.shared.transitory.query.Query;
import io.divide.shared.util.ObjectUtils;
import io.divide.shared.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Wrapper
extends HashMap<String, Object> {
    private static final boolean DEBUG = false;

    public Wrapper() {
    }

    public <B extends TransientObject> Wrapper(B b) {
        this.Key(b.getObjectKey());
        this.Table(Query.safeTable((String)b.getObjectType()));
        this.recursiveSave("user_data", "", b.getUserData());
        this.recursiveSave("meta_data", "", b.getMetaData());
    }

    public String Key() {
        return (String)this.get("Key");
    }

    public void Key(String value) {
        this.put("Key", value);
    }

    public String Table() {
        return (String)this.get("Table");
    }

    public void Table(String value) {
        this.put("Table", value);
    }

    private FileInfo recursiveSave(String root, String current, Object object) {
        String currentPath = current != null && current.length() > 0 ? root + "." + current : root;
        if (ObjectUtils.isMap((Object)object)) {
            Map m = (Map)object;
            Manifest manifest = new Manifest();
            Set objects = m.entrySet();
            for (Map.Entry e : objects) {
                FileInfo coded = this.recursiveSave(currentPath, String.valueOf(e.getKey()), e.getValue());
                manifest.files.add(coded);
            }
            this.put("x." + currentPath, manifest.toString());
            return new FileInfo('x', null, current);
        }
        if (ObjectUtils.isCollection((Object)object)) {
            Object[] array = ((Collection)object).toArray(new Object[0]);
            this.put(currentPath, array);
            return new FileInfo('c', object.getClass(), current);
        }
        if (ObjectUtils.isArray((Object)object)) {
            Object[] array = (Object[])object;
            this.put(currentPath, array);
            return new FileInfo('a', object.getClass(), current);
        }
        this.put(currentPath, object);
        return new FileInfo('n', null, current);
    }

    private void recursiveLoad(String currentPath, Map<String, Object> map) {
        String json = (String)this.get("x." + currentPath);
        Manifest manifest = Manifest.fromString(json);
        for (FileInfo file : manifest.files) {
            String path = file.path;
            switch (file.type) {
                case 'x': {
                    this.recursiveLoad(currentPath + "." + path, map);
                    break;
                }
                case 'a': {
                    Class type = file.clazz;
                    Object[] raw = (Object[])this.get(currentPath + "." + path);
                    Collection<Object> o = type.cast(raw);
                    map.put(path, o);
                    break;
                }
                case 'c': {
                    Class type = file.clazz;
                    Object[] raw = (Object[])this.get(currentPath + "." + path);
                    Collection<Object> o = ObjectUtils.v2c((Object[])raw);
                    map.put(path, o);
                    break;
                }
                case 'n': {
                    Object raw = this.get(currentPath + "." + path);
                    map.put(path, raw);
                }
            }
        }
    }

    private String fromArray(Object o) {
        return "";
    }

    private String fromCollection(Object o) {
        return "";
    }

    public <B extends TransientObject> B toObject(Class<B> type) {
        try {
            Constructor<B> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            TransientObject b = (TransientObject)constructor.newInstance(new Object[0]);
            Map user_data = (Map)ReflectionUtils.getObjectField((Object)b, (String)"user_data");
            Map meta_data = (Map)ReflectionUtils.getObjectField((Object)b, (String)"meta_data");
            user_data.clear();
            meta_data.clear();
            this.recursiveLoad("user_data", user_data);
            this.recursiveLoad("meta_data", meta_data);
            return (B)b;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String toString() {
        return "Wrapper{Table='" + this.Table() + '\'' + "Key='" + this.Key() + '\'' + '}';
    }

    private static class ClassTypeConverter
    implements JsonSerializer<Class>,
    JsonDeserializer<Class> {
        private ClassTypeConverter() {
        }

        public JsonElement serialize(Class src, Type srcType, JsonSerializationContext context) {
            return new JsonPrimitive(src.getName());
        }

        public Class deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            try {
                return Class.forName(json.getAsString());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }

    private static final class FileInfo {
        public char type;
        public Class clazz;
        public String path;

        public FileInfo(char type, Class clazz, String path) {
            this.type = type;
            this.clazz = clazz;
            this.path = path;
        }
    }

    private static final class Manifest {
        private static Gson gson = new GsonBuilder().registerTypeAdapter(Class.class, (Object)new ClassTypeConverter()).create();
        public final List<FileInfo> files = new ArrayList<FileInfo>();

        private Manifest() {
        }

        public String toString() {
            return gson.toJson((Object)this);
        }

        public static Manifest fromString(String string) {
            return (Manifest)gson.fromJson(string, Manifest.class);
        }
    }
}

