/*
 * Decompiled with CFR 0.152.
 */
package io.divide.client.data;

import com.google.gson.Gson;
import io.divide.client.http.Status;
import io.divide.shared.logging.Logger;
import io.divide.shared.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import retrofit.client.Response;

public class ServerResponse<T> {
    private static Gson gson = new Gson();
    private static Logger logger = Logger.getLogger(ServerResponse.class);
    protected T t;
    protected String error;
    protected Status status;

    public static <T> ServerResponse<T> from(Class<T> type, Response response) {
        logger.debug((Object)("from(" + type.getName() + "): " + response.getStatus()));
        ServerResponse<T> o = null;
        try {
            o = new ServerResponse<T>(ServerResponse.convertBody(type, response), Status.valueOf(response.getStatus()), response.getReason());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return o;
    }

    protected ServerResponse(T t, Status status, String error) {
        this.t = t;
        this.status = status;
        this.error = error;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getError() {
        return this.error;
    }

    public T get() {
        return this.t;
    }

    private static <T> T convertBody(Class<T> typeClass, Response response) {
        String body = null;
        try {
            body = IOUtils.toString((InputStream)response.getBody().in());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)gson.fromJson(body, typeClass);
    }
}

