/*
 * Decompiled with CFR 0.152.
 */
package io.divide.client.web;

import com.google.gson.Gson;
import com.google.inject.Inject;
import io.divide.client.Config;
import io.divide.client.web.ConnectionListener;
import io.divide.client.web.OnRequestInterceptor;
import io.divide.client.web.RequestObject;
import io.divide.shared.logging.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import retrofit.Profiler;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import rx.Observer;
import rx.Subscription;
import rx.schedulers.Schedulers;
import rx.subjects.PublishSubject;

public abstract class AbstractWebManager<T> {
    private static Logger logger = Logger.getLogger(AbstractWebManager.class);
    private static Logger retrologger = Logger.getLogger((String)"Retrofit");
    private static Boolean connectionReceiverRegistered = false;
    static final Map<Long, AbstractWebManager> webManagers = new HashMap<Long, AbstractWebManager>();
    protected Config config;
    private List<OnRequestInterceptor> requestInterceptors = new CopyOnWriteArrayList<OnRequestInterceptor>();
    private RestAdapter restAdapter;
    private T t;
    private PublishSubject<RequestObject> requestEventPublisher = PublishSubject.create();
    private PublishSubject<Boolean> connectionEventPublisher = PublishSubject.create();

    protected abstract Class<T> getType();

    @Inject
    protected AbstractWebManager(Config config) {
        this.config = config;
        this.initAdapter(config);
    }

    protected void initAdapter(Config config) {
        Class<T> type = this.getType();
        if (type == null) {
            throw new IllegalStateException("getType can not be null");
        }
        if (!webManagers.containsKey(config.id)) {
            logger.debug((Object)("Creating new RestAdapter for: " + config.id));
            this.restAdapter = this.createRestAdapter(config);
            webManagers.put(config.id, this);
        } else {
            this.restAdapter = AbstractWebManager.webManagers.get((Object)Long.valueOf((long)config.id)).restAdapter;
        }
        this.t = this.restAdapter.create(type);
    }

    public T getWebService() {
        return this.t;
    }

    private RestAdapter createRestAdapter(Config config) {
        RestAdapter.Builder builder = new RestAdapter.Builder();
        builder.setClient((Client)new OkClient(config.client)).setEndpoint(config.serverUrl).setLogLevel(RestAdapter.LogLevel.FULL).setLog(new RestAdapter.Log(){

            public void log(String s) {
                retrologger.debug((Object)s);
            }
        }).setConverter((Converter)new GsonConverter(new Gson())).setRequestInterceptor(new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade requestFacade) {
                AbstractWebManager.this.onRequest(requestFacade);
            }
        }).setProfiler(new Profiler(){

            public Object beforeCall() {
                return null;
            }

            public void afterCall(Profiler.RequestInformation requestInformation, long l, int i, Object o) {
                retrologger.error((Object)("afterCall(" + requestInformation.getRelativePath() + ":" + requestInformation.getMethod() + ": " + i + " : " + o));
                AbstractWebManager.this.requestEventPublisher.onNext((Object)new RequestObject(requestInformation, l, i, o));
            }
        });
        return builder.build();
    }

    private void onRequest(RequestInterceptor.RequestFacade requestFacade) {
        for (OnRequestInterceptor ori : this.requestInterceptors) {
            ori.onRequest(requestFacade);
        }
    }

    public void addConnectionListener(ConnectionListener listener) {
        Subscription subscription = this.connectionEventPublisher.subscribeOn(Schedulers.io()).subscribe(listener.getObserver());
    }

    public final void addResponseObserver(Observer<RequestObject> observer) {
        Subscription subscription = this.requestEventPublisher.subscribeOn(Schedulers.io()).subscribe(observer);
    }

    protected void addRequestInterceptor(OnRequestInterceptor requestInterceptor) {
        this.requestInterceptors.add(requestInterceptor);
    }
}

