/*
 * Decompiled with CFR 0.152.
 */
package io.drdroid.api.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.drdroid.api.Configuration;
import io.drdroid.api.client.IDrDroidAPI;
import io.drdroid.api.models.ClientConfig;
import io.drdroid.api.models.IngestionEvent;
import io.drdroid.api.models.http.request.Data;
import io.drdroid.api.models.http.request.UUIDRegister;
import io.drdroid.api.producer.HTTPProducer;
import io.drdroid.api.utils.IngestionEventTransformer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AsyncClient
implements IDrDroidAPI {
    private static final int MAX_THREADS = 40;
    private static final int MIN_THREADS = 1;
    private static final UUID uuid = UUID.randomUUID();
    private static final Object clientSync = new Object();
    private static AsyncClient instance = null;
    private final AtomicLong droppedCount = new AtomicLong(0L);
    private final AtomicLong eventId = new AtomicLong(0L);
    private final BlockingQueue<IngestionEvent> events = new LinkedBlockingQueue<IngestionEvent>();
    private final Lock registerLock = new ReentrantLock();
    private Boolean registered = false;

    private AsyncClient() {
        this.createQueuePoller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDrDroidAPI getAsyncClientInstance() {
        Object object = clientSync;
        synchronized (object) {
            if (null == instance) {
                instance = new AsyncClient();
            }
        }
        return instance;
    }

    @Override
    public long getSentEventCount() {
        return this.eventId.get();
    }

    @Override
    public long getLostEventCount() {
        return this.droppedCount.get();
    }

    @Override
    public int getNumOfPendingEvents() {
        return this.events.size();
    }

    @Override
    public void send(String eventName, Map<String, ?> kvs, long timestamp) {
        IngestionEvent ingestionEvent = IngestionEventTransformer.transform(eventName, kvs, timestamp);
        if (this.events.size() > ClientConfig.maxQueueSize) {
            this.droppedCount.incrementAndGet();
        } else {
            this.events.add(ingestionEvent);
        }
    }

    private void createQueuePoller() {
        float messageSentPerSecondInSingleThread = 1000 * ClientConfig.asyncBatchSize / ClientConfig.socketTimeoutInMs;
        int threadsRequied = ClientConfig.messagePerSecond / (int)messageSentPerSecondInSingleThread;
        if (threadsRequied > 40) {
            threadsRequied = 40;
        } else if (threadsRequied < 1) {
            threadsRequied = 1;
        }
        ExecutorService poller = Executors.newFixedThreadPool(threadsRequied, new ThreadFactoryBuilder().setNameFormat("AsyncDrDroidClientPoller-%d").build());
        for (int i = 0; i < threadsRequied; ++i) {
            poller.execute(this.createPoller());
        }
    }

    private Runnable createPoller() {
        return () -> {
            while (true) {
                try {
                    while (true) {
                        ArrayList eventSet = new ArrayList();
                        this.events.drainTo(eventSet, ClientConfig.asyncBatchSize);
                        if (!this.registered.booleanValue()) {
                            this.register();
                        }
                        if (eventSet.size() > 0) {
                            ArrayList<IngestionEvent> workflowIngestionEventSet = new ArrayList<IngestionEvent>(eventSet.size());
                            Iterator var5 = eventSet.iterator();
                            while (true) {
                                if (!var5.hasNext()) {
                                    HTTPProducer.getHTTPProducer().sendBatch(new Data(workflowIngestionEventSet));
                                    break;
                                }
                                long eventNum = this.eventId.incrementAndGet();
                                workflowIngestionEventSet.add((IngestionEvent)var5.next());
                            }
                        }
                        if (this.events.size() >= ClientConfig.maxQueueSize) continue;
                        Thread.sleep(ClientConfig.asyncMaxWaitTimeInMs);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        };
    }

    @VisibleForTesting
    protected void register() {
        HashMap<String, String> resourceKvs = new HashMap<String, String>();
        if (this.registerLock.tryLock()) {
            try {
                UUIDRegister register = new UUIDRegister();
                register.setServiceName(Configuration.getServiceName());
                register.setUuid(uuid);
                register.setResourceKvs(resourceKvs);
                register.setIp(InetAddress.getLocalHost().getHostAddress());
                this.registered = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

