/*
 * Decompiled with CFR 0.152.
 */
package io.drdroid.api.producer;

import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import io.drdroid.api.ClientConfiguration;
import io.drdroid.api.ClientRegistry;
import io.drdroid.api.models.http.request.Data;
import io.drdroid.api.models.http.request.RequestPayload;
import io.drdroid.api.models.http.request.UUIDRegister;
import io.drdroid.api.models.http.response.RegisterAPIResponse;
import io.drdroid.api.models.http.response.SendBatchAPIResponse;
import io.drdroid.api.producer.IProducer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import retrofit.Call;
import retrofit.Converter;
import retrofit.JacksonConverterFactory;
import retrofit.Retrofit;
import retrofit.http.Body;
import retrofit.http.POST;

public class HTTPProducer
implements IProducer {
    private static final Object producerSync = new Object();
    public static boolean isInitialisedWithError;
    private static HTTPProducer instance;
    private MessageProducer producer = null;

    public HTTPProducer() {
        try {
            Object apiToken = !ClientRegistry.getApiToken().startsWith("Bearer") ? "Bearer " + ClientRegistry.getApiToken() : ClientRegistry.getApiToken();
            OkHttpClient okHttpClient = new OkHttpClient();
            okHttpClient.setConnectTimeout((long)ClientConfiguration.getConnectionTimeoutInMs(), TimeUnit.MILLISECONDS);
            okHttpClient.setReadTimeout((long)ClientConfiguration.getSocketTimeoutInMs(), TimeUnit.MILLISECONDS);
            okHttpClient.interceptors().add(arg_0 -> HTTPProducer.lambda$new$0((String)apiToken, arg_0));
            Retrofit retrofit = new Retrofit.Builder().baseUrl(ClientRegistry.getSinkUrl()).client(okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
            this.producer = (MessageProducer)retrofit.create(MessageProducer.class);
        }
        catch (Exception ignored) {
            isInitialisedWithError = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HTTPProducer getHTTPProducer() {
        Object object = producerSync;
        synchronized (object) {
            if (null == instance || isInitialisedWithError) {
                instance = new HTTPProducer();
            }
        }
        return instance;
    }

    @Override
    public Integer sendBatch(Data data) {
        if (null == this.producer) {
            return 0;
        }
        Call<SendBatchAPIResponse> call = this.producer.send(new RequestPayload(data));
        try {
            retrofit.Response response = call.execute();
            return ((SendBatchAPIResponse)response.body()).getCount();
        }
        catch (IOException var4) {
            var4.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean register(UUIDRegister register) {
        if (null == HTTPProducer.instance.producer) {
            return false;
        }
        Call<RegisterAPIResponse> call = HTTPProducer.instance.producer.register(register);
        try {
            retrofit.Response response = call.execute();
            return ((RegisterAPIResponse)response.body()).getSuccess();
        }
        catch (IOException var4) {
            var4.printStackTrace();
            return false;
        }
    }

    @Override
    public void sendBeat(UUIDRegister register) {
    }

    private static /* synthetic */ Response lambda$new$0(String apiToken, Interceptor.Chain chain) throws IOException {
        Request request = chain.request().newBuilder().addHeader("Content-Type", "application/json").addHeader("Authorization", apiToken).build();
        return chain.proceed(request);
    }

    static {
        instance = null;
    }

    protected static interface MessageProducer {
        @POST(value="e/ingest/events/v2")
        public Call<SendBatchAPIResponse> send(@Body RequestPayload var1);

        @POST(value="e/agent/register")
        public Call<RegisterAPIResponse> register(@Body UUIDRegister var1);

        @POST(value="e/agent/register")
        public Call<RegisterAPIResponse> sendBeat(@Body UUIDRegister var1);
    }
}

