/*
 * Decompiled with CFR 0.152.
 */
package io.drdroid.api.utils;

import io.drdroid.api.models.IngestionEvent;
import io.drdroid.api.models.kvs.KeyValue;
import io.drdroid.api.models.kvs.Value;
import io.drdroid.api.utils.ObjectToMapTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class IngestionEventTransformer {
    public static IngestionEvent transform(String eventName, Map<String, ?> kvPairs, long timeStamp) {
        List<KeyValue> modelKvPairs = IngestionEventTransformer.getKvs(kvPairs);
        return new IngestionEvent(eventName, modelKvPairs, timeStamp);
    }

    private static List<KeyValue> getKvs(Map<String, ?> input) {
        ArrayList<KeyValue> generatedPairs = new ArrayList<KeyValue>();
        input.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                generatedPairs.add(new KeyValue(key, Value.newKvValueList(IngestionEventTransformer.getKvs((Map)value))));
            } else if (value instanceof List) {
                generatedPairs.add(new KeyValue(key, Value.newArrayValue(IngestionEventTransformer.getArrayValue(value))));
            } else {
                generatedPairs.add(new KeyValue(key, IngestionEventTransformer.getPrimitiveValue(value)));
            }
        });
        return generatedPairs;
    }

    private static List<Value> getArrayValue(Object value) {
        ArrayList<Value> typedValues = new ArrayList<Value>();
        ((List)value).forEach(v -> {
            if (v instanceof List) {
                typedValues.addAll(IngestionEventTransformer.getArrayValue(v));
            } else if (v instanceof Map) {
                typedValues.add(Value.newKvValueList(IngestionEventTransformer.getKvs((Map)v)));
            } else {
                typedValues.add(IngestionEventTransformer.getPrimitiveValue(v));
            }
        });
        return typedValues;
    }

    private static Value getPrimitiveValue(Object value) {
        if (value instanceof String) {
            return Value.newStringValue((String)value);
        }
        if (value instanceof Boolean) {
            return Value.newBooleanValue((Boolean)value);
        }
        if (value instanceof Integer) {
            return Value.newLongValue((long)((Integer)value));
        }
        if (value instanceof Long) {
            return Value.newLongValue((Long)value);
        }
        if (value instanceof Float) {
            return Value.newDoubleValue(Double.valueOf(((Float)value).floatValue()));
        }
        if (value instanceof Double) {
            return Value.newDoubleValue((Double)value);
        }
        return Value.newKvValueList(IngestionEventTransformer.getKvs(ObjectToMapTemplate.convertObjectToMap(value)));
    }
}

