/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Rule(key="EC79")
@DeprecatedRuleKey(repositoryKey="greencodeinitiative-java", ruleKey="S79")
public class FreeResourcesOfAutoCloseableInterface
extends IssuableSubscriptionVisitor {
    private final Deque<TryStatementTree> withinTry = new LinkedList<TryStatementTree>();
    private final Deque<List<Tree>> toReport = new LinkedList<List<Tree>>();
    private static final String JAVA_LANG_AUTOCLOSEABLE = "java.lang.AutoCloseable";
    protected static final String MESSAGE_RULE = "try-with-resources Statement needs to be implemented for any object that implements the AutoClosable interface.";

    @ParametersAreNonnullByDefault
    public void leaveFile(JavaFileScannerContext context) {
        this.withinTry.clear();
        this.toReport.clear();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.TRY_STATEMENT, Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT})) {
            this.withinTry.push((TryStatementTree)tree);
            if (this.withinTry.size() != this.toReport.size()) {
                this.toReport.push(new ArrayList());
            }
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && ((NewClassTree)tree).symbolType().isSubtypeOf(JAVA_LANG_AUTOCLOSEABLE) && this.withinStandardTryWithFinally()) {
            assert (this.toReport.peek() != null);
            this.toReport.peek().add(tree);
        }
    }

    public void leaveNode(Tree tree) {
        List<Tree> secondaryTrees;
        if (tree.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT}) && !(secondaryTrees = this.toReport.pop()).isEmpty()) {
            this.reportIssue(tree, MESSAGE_RULE);
        }
    }

    private boolean withinStandardTryWithFinally() {
        if (this.withinTry.isEmpty() || !this.withinTry.peek().resourceList().isEmpty()) {
            return false;
        }
        assert (this.withinTry.peek() != null);
        return this.withinTry.peek().finallyBlock() != null;
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava7Compatible();
    }
}

