/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.python.checks;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Rule(key="EC7")
@DeprecatedRuleKey(repositoryKey="gci-python", ruleKey="D7")
public class AvoidGettersAndSetters
extends PythonSubscriptionCheck {
    public static final String DESCRIPTION = "Avoid creating getter and setter methods in classes";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            StatementList statementList = functionDef.body();
            List statements = statementList.statements();
            if (functionDef.parent().parent().is(new Tree.Kind[]{Tree.Kind.CLASSDEF})) {
                this.checkAllGetters(statements, functionDef, (SubscriptionContext)ctx);
                this.checkAllSetters(statements, functionDef, (SubscriptionContext)ctx);
            }
        });
    }

    public void checkAllSetters(List<Statement> statements, FunctionDef functionDef, SubscriptionContext ctx) {
        ParameterList parameters;
        AssignmentStatement assignmentStatement;
        if (statements.size() == 1 && statements.get(0).is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT}) && this.checkIfStatementIsQualifiedExpressionAndStartsWithSelfDot((QualifiedExpression)((Tree)(assignmentStatement = (AssignmentStatement)statements.get(0)).children().get(0)).children().get(0)) && (parameters = functionDef.parameters()) != null && !parameters.all().stream().filter(p -> this.checkAssignementFromParameter(assignmentStatement, (AnyParameter)p)).collect(Collectors.toList()).isEmpty()) {
            ctx.addIssue(functionDef.defKeyword(), DESCRIPTION);
        }
    }

    public void checkAllGetters(List<Statement> statements, FunctionDef functionDef, SubscriptionContext ctx) {
        List returnStatementChildren;
        Statement lastStatement = statements.get(statements.size() - 1);
        if (lastStatement.is(new Tree.Kind[]{Tree.Kind.RETURN_STMT}) && ((Tree)(returnStatementChildren = ((ReturnStatement)lastStatement).children()).get(1)).is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR}) && this.checkIfStatementIsQualifiedExpressionAndStartsWithSelfDot((QualifiedExpression)returnStatementChildren.get(1))) {
            ctx.addIssue(functionDef.defKeyword(), DESCRIPTION);
        }
    }

    public boolean checkAssignementFromParameter(AssignmentStatement assignmentStatement, AnyParameter parameter) {
        String parameterToString = parameter.firstToken().value();
        return assignmentStatement.assignedValue().firstToken().value().equalsIgnoreCase(parameterToString);
    }

    public boolean checkIfStatementIsQualifiedExpressionAndStartsWithSelfDot(QualifiedExpression qualifiedExpression) {
        List qualifedExpressionChildren = qualifiedExpression.children();
        return qualifedExpressionChildren.size() == 3 && ((Tree)qualifedExpressionChildren.get(0)).firstToken().value().equalsIgnoreCase("self") && ((Tree)qualifedExpressionChildren.get(1)).firstToken().value().equalsIgnoreCase(".");
    }
}

