/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Rule(key="EC69")
@DeprecatedRuleKey(repositoryKey="gci-python", ruleKey="S69")
public class NoFunctionCallWhenDeclaringForLoop
extends PythonSubscriptionCheck {
    public static final String DESCRIPTION = "Do not call a function when declaring a for-type loop";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            if (callExpression.parent().getKind() == Tree.Kind.FOR_STMT) {
                ctx.addIssue((Tree)callExpression, DESCRIPTION);
            }
        });
    }
}

