/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.caching;

import io.fluxcapacitor.javaclient.common.caching.Cache;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class DefaultCache
implements Cache {
    private final LinkedHashMap<String, Object> cache;

    public DefaultCache() {
        this(1000);
    }

    public DefaultCache(final int maxSize) {
        this.cache = new LinkedHashMap<String, Object>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > maxSize;
            }
        };
    }

    @Override
    public void put(String id, Object value) {
        this.cache.put(id, value);
    }

    @Override
    public <T> T get(String id, Function<? super String, T> mappingFunction) {
        T result = this.getIfPresent(id);
        if (result == null) {
            result = mappingFunction.apply(id);
            this.cache.putIfAbsent(id, result);
        }
        return result;
    }

    @Override
    public <T> T getIfPresent(String id) {
        return (T)this.cache.get(id);
    }

    @Override
    public void invalidate(String id) {
        this.cache.remove(id);
    }

    @Override
    public void invalidateAll() {
        this.cache.clear();
    }
}

