/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.metrics;

import io.fluxcapacitor.common.api.ClientEvent;
import java.beans.ConstructorProperties;

public final class ApplicationMetricsEvent
implements ClientEvent {
    private final String client;
    private final String clientId;
    private final long timestamp = System.currentTimeMillis();
    private final double cpuUsage;
    private final long memoryUsage;
    private final int threadCount;
    private final double averageGarbageCollectionTime;

    @ConstructorProperties(value={"client", "clientId", "cpuUsage", "memoryUsage", "threadCount", "averageGarbageCollectionTime"})
    public ApplicationMetricsEvent(String client, String clientId, double cpuUsage, long memoryUsage, int threadCount, double averageGarbageCollectionTime) {
        this.client = client;
        this.clientId = clientId;
        this.cpuUsage = cpuUsage;
        this.memoryUsage = memoryUsage;
        this.threadCount = threadCount;
        this.averageGarbageCollectionTime = averageGarbageCollectionTime;
    }

    public String getClient() {
        return this.client;
    }

    public String getClientId() {
        return this.clientId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public double getCpuUsage() {
        return this.cpuUsage;
    }

    public long getMemoryUsage() {
        return this.memoryUsage;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public double getAverageGarbageCollectionTime() {
        return this.averageGarbageCollectionTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationMetricsEvent)) {
            return false;
        }
        ApplicationMetricsEvent other = (ApplicationMetricsEvent)o;
        String this$client = this.getClient();
        String other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (Double.compare(this.getCpuUsage(), other.getCpuUsage()) != 0) {
            return false;
        }
        if (this.getMemoryUsage() != other.getMemoryUsage()) {
            return false;
        }
        if (this.getThreadCount() != other.getThreadCount()) {
            return false;
        }
        return Double.compare(this.getAverageGarbageCollectionTime(), other.getAverageGarbageCollectionTime()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $cpuUsage = Double.doubleToLongBits(this.getCpuUsage());
        result = result * 59 + (int)($cpuUsage >>> 32 ^ $cpuUsage);
        long $memoryUsage = this.getMemoryUsage();
        result = result * 59 + (int)($memoryUsage >>> 32 ^ $memoryUsage);
        result = result * 59 + this.getThreadCount();
        long $averageGarbageCollectionTime = Double.doubleToLongBits(this.getAverageGarbageCollectionTime());
        result = result * 59 + (int)($averageGarbageCollectionTime >>> 32 ^ $averageGarbageCollectionTime);
        return result;
    }

    public String toString() {
        return "ApplicationMetricsEvent(client=" + this.getClient() + ", clientId=" + this.getClientId() + ", timestamp=" + this.getTimestamp() + ", cpuUsage=" + this.getCpuUsage() + ", memoryUsage=" + this.getMemoryUsage() + ", threadCount=" + this.getThreadCount() + ", averageGarbageCollectionTime=" + this.getAverageGarbageCollectionTime() + ")";
    }
}

