/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.MessageFormatter;
import java.beans.ConstructorProperties;
import java.time.Instant;

public final class DeserializingMessage {
    public static MessageFormatter messageFormatter = MessageFormatter.DEFAULT;
    private static final ThreadLocal<DeserializingMessage> current = new ThreadLocal();
    private final DeserializingObject<byte[], SerializedMessage> delegate;
    private final MessageType messageType;

    public Metadata getMetadata() {
        return this.delegate.getSerializedObject().getMetadata();
    }

    public Message toMessage() {
        return new Message(this.delegate.getPayload(), this.getMetadata(), this.delegate.getSerializedObject().getMessageId(), Instant.ofEpochMilli(this.delegate.getSerializedObject().getTimestamp()));
    }

    public static void setCurrent(DeserializingMessage message) {
        current.set(message);
    }

    public static DeserializingMessage getCurrent() {
        return current.get();
    }

    public static void removeCurrent() {
        current.remove();
    }

    public String toString() {
        return (String)messageFormatter.apply(this);
    }

    @ConstructorProperties(value={"delegate", "messageType"})
    public DeserializingMessage(DeserializingObject<byte[], SerializedMessage> delegate, MessageType messageType) {
        this.delegate = delegate;
        this.messageType = messageType;
    }

    public DeserializingObject<byte[], SerializedMessage> getDelegate() {
        return this.delegate;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeserializingMessage)) {
            return false;
        }
        DeserializingMessage other = (DeserializingMessage)o;
        DeserializingObject<byte[], SerializedMessage> this$delegate = this.getDelegate();
        DeserializingObject<byte[], SerializedMessage> other$delegate = other.getDelegate();
        if (this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate)) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        return !(this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeserializingObject<byte[], SerializedMessage> $delegate = this.getDelegate();
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        return result;
    }

    public Object getPayload() {
        return this.getDelegate().getPayload();
    }

    public boolean isDeserialized() {
        return this.getDelegate().isDeserialized();
    }

    public String getType() {
        return this.getDelegate().getType();
    }

    public int getRevision() {
        return this.getDelegate().getRevision();
    }

    public SerializedMessage getSerializedObject() {
        return this.getDelegate().getSerializedObject();
    }

    public Class<?> getPayloadClass() {
        return this.getDelegate().getPayloadClass();
    }
}

