/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import java.beans.ConstructorProperties;
import java.util.function.Function;

public class MessageSerializer {
    private final Function<Message, SerializedMessage> serializer;

    public MessageSerializer(Serializer serializer, DispatchInterceptor dispatchInterceptor, MessageType messageType) {
        this(dispatchInterceptor.interceptDispatch(m -> new SerializedMessage(serializer.serialize(m.getPayload()), m.getMetadata(), m.getMessageId(), Long.valueOf(m.getTimestamp().toEpochMilli())), messageType));
    }

    public SerializedMessage serialize(Message message) {
        return this.serializer.apply(message);
    }

    @ConstructorProperties(value={"serializer"})
    public MessageSerializer(Function<Message, SerializedMessage> serializer) {
        this.serializer = serializer;
    }
}

