/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.websocket;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.RetryConfiguration;
import io.fluxcapacitor.common.TimingUtils;
import io.fluxcapacitor.common.api.JsonType;
import io.fluxcapacitor.common.api.QueryResult;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.javaclient.common.serialization.compression.CompressionUtils;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DecodeException;
import javax.websocket.EncodeException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebsocketClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AbstractWebsocketClient.class);
    public static final ObjectMapper defaultObjectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final WebSocketContainer container;
    private final URI endpointUri;
    private final WebSocketClient.Properties properties;
    private final ObjectMapper objectMapper;
    private final Map<Long, WebSocketRequest> requests = new ConcurrentHashMap<Long, WebSocketRequest>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final RetryConfiguration retryConfig;
    private volatile Session session;

    public AbstractWebsocketClient(URI endpointUri, WebSocketClient.Properties properties) {
        this(ContainerProvider.getWebSocketContainer(), endpointUri, properties, Duration.ofSeconds(1L), defaultObjectMapper);
    }

    public AbstractWebsocketClient(WebSocketContainer container, URI endpointUri, WebSocketClient.Properties properties, Duration reconnectDelay, ObjectMapper objectMapper) {
        this.container = container;
        this.endpointUri = endpointUri;
        this.properties = properties;
        this.objectMapper = objectMapper;
        this.retryConfig = RetryConfiguration.builder().delay(reconnectDelay).errorTest(e -> !this.closed.get()).successLogger(s -> log.info("Successfully reconnected to endpoint {}", (Object)endpointUri)).exceptionLogger(status -> {
            if (status.getNumberOfTimesRetried() == 0) {
                log.warn("Failed to connect to endpoint {}; reason: {}. Retrying every {} ms...", new Object[]{endpointUri, status.getException().getMessage(), status.getRetryConfiguration().getDelay().toMillis()});
            }
        }).build();
    }

    protected Awaitable send(Object object) {
        try (OutputStream outputStream = this.getSession().getBasicRemote().getSendStream();){
            byte[] bytes = this.objectMapper.writeValueAsBytes(object);
            outputStream.write(CompressionUtils.compress(bytes, this.properties.getCompression()));
        }
        catch (Exception e) {
            throw new EncodeException(object, String.format("Could not convert %s to json", object), (Throwable)e);
        }
        return Awaitable.ready();
    }

    protected <R extends QueryResult> R sendRequestAndWait(Request request) {
        return (R)((QueryResult)this.sendRequest(request).get());
    }

    protected <R extends QueryResult> CompletableFuture<R> sendRequest(Request request) {
        WebSocketRequest webSocketRequest = new WebSocketRequest(request);
        this.requests.put(request.getRequestId(), webSocketRequest);
        try {
            webSocketRequest.send(this.getSession());
        }
        catch (Exception e2) {
            this.requests.remove(request.getRequestId());
            throw new IllegalStateException("Failed to send request " + request, e2);
        }
        return webSocketRequest.result.whenComplete((r, e) -> {
            if (e != null) {
                log.error("Failed to handle request {}", (Object)request, e);
            }
            this.requests.remove(request.getRequestId());
        });
    }

    @OnMessage
    public void onMessage(byte[] bytes) {
        JsonType value;
        try {
            value = (JsonType)this.objectMapper.readValue(CompressionUtils.decompress(bytes, this.properties.getCompression()), JsonType.class);
        }
        catch (Exception e) {
            throw new DecodeException("", "Could not parse input. Expected a Json message.", (Throwable)e);
        }
        QueryResult readResult = (QueryResult)value;
        WebSocketRequest webSocketRequest = this.requests.remove(readResult.getRequestId());
        if (webSocketRequest == null) {
            log.warn("Could not find outstanding read request for id {}", (Object)readResult.getRequestId());
        } else {
            webSocketRequest.complete(readResult);
        }
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        if (closeReason.getCloseCode().getCode() > CloseReason.CloseCodes.NO_STATUS_CODE.getCode()) {
            log.warn("Connection to endpoint {} closed with reason {}", (Object)session.getRequestURI(), (Object)closeReason);
        }
        this.retryOutstandingRequests(session.getId());
    }

    protected void retryOutstandingRequests(String sessionId) {
        if (!this.closed.get() && !this.requests.isEmpty()) {
            try {
                Thread.sleep(this.retryConfig.getDelay().toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Thread interrupted while trying to retry outstanding requests", e);
            }
            this.requests.values().stream().filter(r -> sessionId.equals(r.getSessionId())).forEach(r -> {
                try {
                    r.send(this.getSession());
                }
                catch (Exception e) {
                    r.completeExceptionally(e);
                }
            });
        }
    }

    @OnError
    public void onError(Session session, Throwable e) {
        log.error("Client side error for web socket connected to endpoint {}", (Object)session.getRequestURI(), (Object)e);
    }

    @Override
    public void close() {
        this.close(false);
    }

    protected void close(boolean clearOutstandingRequests) {
        if (this.closed.compareAndSet(false, true)) {
            if (clearOutstandingRequests) {
                this.requests.clear();
            }
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (IOException e) {
                    log.warn("Failed to closed websocket session connected to endpoint {}. Reason: {}", (Object)this.session.getRequestURI(), (Object)e.getMessage());
                }
            }
            if (this.session != null && !this.requests.isEmpty()) {
                log.warn("Closed websocket session to endpoint {} with {} outstanding requests", (Object)this.session.getRequestURI(), (Object)this.requests.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session getSession() {
        if (this.isClosed(this.session)) {
            AbstractWebsocketClient abstractWebsocketClient = this;
            synchronized (abstractWebsocketClient) {
                while (this.isClosed(this.session)) {
                    this.session = (Session)TimingUtils.retryOnFailure(() -> this.isClosed(this.session) ? this.container.connectToServer((Object)this, this.endpointUri) : this.session, (RetryConfiguration)this.retryConfig);
                }
            }
        }
        return this.session;
    }

    protected boolean isClosed(Session session) {
        return session == null || !session.isOpen();
    }

    protected class WebSocketRequest {
        private final Request request;
        private final CompletableFuture<QueryResult> result = new CompletableFuture();
        private volatile String sessionId;

        protected void send(Session session) {
            this.sessionId = session.getId();
            AbstractWebsocketClient.this.send(this.request);
        }

        protected void completeExceptionally(Throwable e) {
            this.result.completeExceptionally(e);
        }

        protected void complete(QueryResult value) {
            this.result.complete(value);
        }

        public QueryResult getResult() throws ExecutionException, InterruptedException {
            return this.result.get();
        }

        @ConstructorProperties(value={"request"})
        public WebSocketRequest(Request request) {
            this.request = request;
        }

        public String getSessionId() {
            return this.sessionId;
        }
    }
}

