/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.eventsourcing;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import java.beans.ConstructorProperties;
import java.util.function.Function;
import java.util.stream.Stream;

public class EventStoreSerializer {
    private final Function<Message, SerializedMessage> serializer;
    private final Serializer deserializer;

    public EventStoreSerializer(Serializer serializer, DispatchInterceptor dispatchInterceptor) {
        this(dispatchInterceptor.interceptDispatch(m -> new SerializedMessage(serializer.serialize(m.getPayload()), m.getMetadata(), m.getMessageId(), Long.valueOf(m.getTimestamp().toEpochMilli())), MessageType.EVENT), serializer);
    }

    public EventStoreSerializer(Serializer serializer) {
        this((Message m) -> new SerializedMessage(serializer.serialize(m.getPayload()), m.getMetadata(), m.getMessageId(), Long.valueOf(m.getTimestamp().toEpochMilli())), serializer);
    }

    public SerializedMessage serialize(Message message) {
        return this.serializer.apply(message);
    }

    public Stream<DeserializingMessage> deserializeDomainEvents(Stream<SerializedMessage> messageStream) {
        return this.deserializer.deserialize(messageStream, true).map(m -> new DeserializingMessage((DeserializingObject<byte[], SerializedMessage>)m, MessageType.EVENT));
    }

    @ConstructorProperties(value={"serializer", "deserializer"})
    public EventStoreSerializer(Function<Message, SerializedMessage> serializer, Serializer deserializer) {
        this.serializer = serializer;
        this.deserializer = deserializer;
    }
}

