/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.MessageSerializer;
import io.fluxcapacitor.javaclient.publishing.GatewayException;
import io.fluxcapacitor.javaclient.publishing.MetricsGateway;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetricsGateway
implements MetricsGateway {
    private static final Logger log = LoggerFactory.getLogger(DefaultMetricsGateway.class);
    private final GatewayClient metricsGateway;
    private final MessageSerializer serializer;

    @Override
    public void publish(Object payload, Metadata metadata) {
        try {
            this.metricsGateway.send(this.serializer.serialize(new Message(payload, metadata)));
        }
        catch (Exception e) {
            throw new GatewayException(String.format("Failed to publish metrics %s", payload), e);
        }
    }

    @ConstructorProperties(value={"metricsGateway", "serializer"})
    public DefaultMetricsGateway(GatewayClient metricsGateway, MessageSerializer serializer) {
        this.metricsGateway = metricsGateway;
        this.serializer = serializer;
    }
}

