/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.api.tracking.TrackingStrategy;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;

public final class TrackingConfiguration {
    public static final TrackingConfiguration DEFAULT = TrackingConfiguration.builder().build();
    private final int threads;
    private final String typeFilter;
    private final int maxFetchBatchSize;
    private final int maxConsumerBatchSize;
    private final Duration maxWaitDuration;
    private final Duration retryDelay;
    private final List<BatchInterceptor> batchInterceptors;
    private final boolean ignoreMessageTarget;
    private final TrackingStrategy readStrategy;
    private final Supplier<String> trackerIdFactory;

    private static int $default$threads() {
        return 1;
    }

    private static String $default$typeFilter() {
        return null;
    }

    private static int $default$maxFetchBatchSize() {
        return 1024;
    }

    private static int $default$maxConsumerBatchSize() {
        return 1024;
    }

    private static Duration $default$maxWaitDuration() {
        return Duration.ofSeconds(60L);
    }

    private static Duration $default$retryDelay() {
        return Duration.ofSeconds(1L);
    }

    private static boolean $default$ignoreMessageTarget() {
        return false;
    }

    private static TrackingStrategy $default$readStrategy() {
        return TrackingStrategy.NEW;
    }

    private static Supplier<String> $default$trackerIdFactory() {
        return () -> UUID.randomUUID().toString();
    }

    @ConstructorProperties(value={"threads", "typeFilter", "maxFetchBatchSize", "maxConsumerBatchSize", "maxWaitDuration", "retryDelay", "batchInterceptors", "ignoreMessageTarget", "readStrategy", "trackerIdFactory"})
    TrackingConfiguration(int threads, String typeFilter, int maxFetchBatchSize, int maxConsumerBatchSize, Duration maxWaitDuration, Duration retryDelay, List<BatchInterceptor> batchInterceptors, boolean ignoreMessageTarget, TrackingStrategy readStrategy, Supplier<String> trackerIdFactory) {
        this.threads = threads;
        this.typeFilter = typeFilter;
        this.maxFetchBatchSize = maxFetchBatchSize;
        this.maxConsumerBatchSize = maxConsumerBatchSize;
        this.maxWaitDuration = maxWaitDuration;
        this.retryDelay = retryDelay;
        this.batchInterceptors = batchInterceptors;
        this.ignoreMessageTarget = ignoreMessageTarget;
        this.readStrategy = readStrategy;
        this.trackerIdFactory = trackerIdFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder().threads(this.threads).typeFilter(this.typeFilter).maxFetchBatchSize(this.maxFetchBatchSize).maxConsumerBatchSize(this.maxConsumerBatchSize).maxWaitDuration(this.maxWaitDuration).retryDelay(this.retryDelay).ignoreMessageTarget(this.ignoreMessageTarget).readStrategy(this.readStrategy).trackerIdFactory(this.trackerIdFactory);
        if (this.batchInterceptors != null) {
            builder.batchInterceptors(this.batchInterceptors);
        }
        return builder;
    }

    public int getThreads() {
        return this.threads;
    }

    public String getTypeFilter() {
        return this.typeFilter;
    }

    public int getMaxFetchBatchSize() {
        return this.maxFetchBatchSize;
    }

    public int getMaxConsumerBatchSize() {
        return this.maxConsumerBatchSize;
    }

    public Duration getMaxWaitDuration() {
        return this.maxWaitDuration;
    }

    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    public List<BatchInterceptor> getBatchInterceptors() {
        return this.batchInterceptors;
    }

    public boolean ignoreMessageTarget() {
        return this.ignoreMessageTarget;
    }

    public TrackingStrategy getReadStrategy() {
        return this.readStrategy;
    }

    public Supplier<String> getTrackerIdFactory() {
        return this.trackerIdFactory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrackingConfiguration)) {
            return false;
        }
        TrackingConfiguration other = (TrackingConfiguration)o;
        if (this.getThreads() != other.getThreads()) {
            return false;
        }
        String this$typeFilter = this.getTypeFilter();
        String other$typeFilter = other.getTypeFilter();
        if (this$typeFilter == null ? other$typeFilter != null : !this$typeFilter.equals(other$typeFilter)) {
            return false;
        }
        if (this.getMaxFetchBatchSize() != other.getMaxFetchBatchSize()) {
            return false;
        }
        if (this.getMaxConsumerBatchSize() != other.getMaxConsumerBatchSize()) {
            return false;
        }
        Duration this$maxWaitDuration = this.getMaxWaitDuration();
        Duration other$maxWaitDuration = other.getMaxWaitDuration();
        if (this$maxWaitDuration == null ? other$maxWaitDuration != null : !((Object)this$maxWaitDuration).equals(other$maxWaitDuration)) {
            return false;
        }
        Duration this$retryDelay = this.getRetryDelay();
        Duration other$retryDelay = other.getRetryDelay();
        if (this$retryDelay == null ? other$retryDelay != null : !((Object)this$retryDelay).equals(other$retryDelay)) {
            return false;
        }
        List<BatchInterceptor> this$batchInterceptors = this.getBatchInterceptors();
        List<BatchInterceptor> other$batchInterceptors = other.getBatchInterceptors();
        if (this$batchInterceptors == null ? other$batchInterceptors != null : !((Object)this$batchInterceptors).equals(other$batchInterceptors)) {
            return false;
        }
        if (this.ignoreMessageTarget() != other.ignoreMessageTarget()) {
            return false;
        }
        TrackingStrategy this$readStrategy = this.getReadStrategy();
        TrackingStrategy other$readStrategy = other.getReadStrategy();
        if (this$readStrategy == null ? other$readStrategy != null : !this$readStrategy.equals(other$readStrategy)) {
            return false;
        }
        Supplier<String> this$trackerIdFactory = this.getTrackerIdFactory();
        Supplier<String> other$trackerIdFactory = other.getTrackerIdFactory();
        return !(this$trackerIdFactory == null ? other$trackerIdFactory != null : !this$trackerIdFactory.equals(other$trackerIdFactory));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getThreads();
        String $typeFilter = this.getTypeFilter();
        result = result * 59 + ($typeFilter == null ? 43 : $typeFilter.hashCode());
        result = result * 59 + this.getMaxFetchBatchSize();
        result = result * 59 + this.getMaxConsumerBatchSize();
        Duration $maxWaitDuration = this.getMaxWaitDuration();
        result = result * 59 + ($maxWaitDuration == null ? 43 : ((Object)$maxWaitDuration).hashCode());
        Duration $retryDelay = this.getRetryDelay();
        result = result * 59 + ($retryDelay == null ? 43 : ((Object)$retryDelay).hashCode());
        List<BatchInterceptor> $batchInterceptors = this.getBatchInterceptors();
        result = result * 59 + ($batchInterceptors == null ? 43 : ((Object)$batchInterceptors).hashCode());
        result = result * 59 + (this.ignoreMessageTarget() ? 79 : 97);
        TrackingStrategy $readStrategy = this.getReadStrategy();
        result = result * 59 + ($readStrategy == null ? 43 : $readStrategy.hashCode());
        Supplier<String> $trackerIdFactory = this.getTrackerIdFactory();
        result = result * 59 + ($trackerIdFactory == null ? 43 : $trackerIdFactory.hashCode());
        return result;
    }

    public String toString() {
        return "TrackingConfiguration(threads=" + this.getThreads() + ", typeFilter=" + this.getTypeFilter() + ", maxFetchBatchSize=" + this.getMaxFetchBatchSize() + ", maxConsumerBatchSize=" + this.getMaxConsumerBatchSize() + ", maxWaitDuration=" + this.getMaxWaitDuration() + ", retryDelay=" + this.getRetryDelay() + ", batchInterceptors=" + this.getBatchInterceptors() + ", ignoreMessageTarget=" + this.ignoreMessageTarget() + ", readStrategy=" + this.getReadStrategy() + ", trackerIdFactory=" + this.getTrackerIdFactory() + ")";
    }

    public static class Builder {
        private boolean threads$set;
        private int threads$value;
        private boolean typeFilter$set;
        private String typeFilter$value;
        private boolean maxFetchBatchSize$set;
        private int maxFetchBatchSize$value;
        private boolean maxConsumerBatchSize$set;
        private int maxConsumerBatchSize$value;
        private boolean maxWaitDuration$set;
        private Duration maxWaitDuration$value;
        private boolean retryDelay$set;
        private Duration retryDelay$value;
        private ArrayList<BatchInterceptor> batchInterceptors;
        private boolean ignoreMessageTarget$set;
        private boolean ignoreMessageTarget$value;
        private boolean readStrategy$set;
        private TrackingStrategy readStrategy$value;
        private boolean trackerIdFactory$set;
        private Supplier<String> trackerIdFactory$value;

        Builder() {
        }

        public Builder threads(int threads) {
            this.threads$value = threads;
            this.threads$set = true;
            return this;
        }

        public Builder typeFilter(String typeFilter) {
            this.typeFilter$value = typeFilter;
            this.typeFilter$set = true;
            return this;
        }

        public Builder maxFetchBatchSize(int maxFetchBatchSize) {
            this.maxFetchBatchSize$value = maxFetchBatchSize;
            this.maxFetchBatchSize$set = true;
            return this;
        }

        public Builder maxConsumerBatchSize(int maxConsumerBatchSize) {
            this.maxConsumerBatchSize$value = maxConsumerBatchSize;
            this.maxConsumerBatchSize$set = true;
            return this;
        }

        public Builder maxWaitDuration(Duration maxWaitDuration) {
            this.maxWaitDuration$value = maxWaitDuration;
            this.maxWaitDuration$set = true;
            return this;
        }

        public Builder retryDelay(Duration retryDelay) {
            this.retryDelay$value = retryDelay;
            this.retryDelay$set = true;
            return this;
        }

        public Builder batchInterceptor(BatchInterceptor batchInterceptor) {
            if (this.batchInterceptors == null) {
                this.batchInterceptors = new ArrayList();
            }
            this.batchInterceptors.add(batchInterceptor);
            return this;
        }

        public Builder batchInterceptors(Collection<? extends BatchInterceptor> batchInterceptors) {
            if (this.batchInterceptors == null) {
                this.batchInterceptors = new ArrayList();
            }
            this.batchInterceptors.addAll(batchInterceptors);
            return this;
        }

        public Builder clearBatchInterceptors() {
            if (this.batchInterceptors != null) {
                this.batchInterceptors.clear();
            }
            return this;
        }

        public Builder ignoreMessageTarget(boolean ignoreMessageTarget) {
            this.ignoreMessageTarget$value = ignoreMessageTarget;
            this.ignoreMessageTarget$set = true;
            return this;
        }

        public Builder readStrategy(TrackingStrategy readStrategy) {
            this.readStrategy$value = readStrategy;
            this.readStrategy$set = true;
            return this;
        }

        public Builder trackerIdFactory(Supplier<String> trackerIdFactory) {
            this.trackerIdFactory$value = trackerIdFactory;
            this.trackerIdFactory$set = true;
            return this;
        }

        public TrackingConfiguration build() {
            List<BatchInterceptor> batchInterceptors;
            switch (this.batchInterceptors == null ? 0 : this.batchInterceptors.size()) {
                case 0: {
                    batchInterceptors = Collections.emptyList();
                    break;
                }
                case 1: {
                    batchInterceptors = Collections.singletonList(this.batchInterceptors.get(0));
                    break;
                }
                default: {
                    batchInterceptors = Collections.unmodifiableList(new ArrayList<BatchInterceptor>(this.batchInterceptors));
                }
            }
            int threads$value = this.threads$value;
            if (!this.threads$set) {
                threads$value = TrackingConfiguration.$default$threads();
            }
            String typeFilter$value = this.typeFilter$value;
            if (!this.typeFilter$set) {
                typeFilter$value = TrackingConfiguration.$default$typeFilter();
            }
            int maxFetchBatchSize$value = this.maxFetchBatchSize$value;
            if (!this.maxFetchBatchSize$set) {
                maxFetchBatchSize$value = TrackingConfiguration.$default$maxFetchBatchSize();
            }
            int maxConsumerBatchSize$value = this.maxConsumerBatchSize$value;
            if (!this.maxConsumerBatchSize$set) {
                maxConsumerBatchSize$value = TrackingConfiguration.$default$maxConsumerBatchSize();
            }
            Duration maxWaitDuration$value = this.maxWaitDuration$value;
            if (!this.maxWaitDuration$set) {
                maxWaitDuration$value = TrackingConfiguration.$default$maxWaitDuration();
            }
            Duration retryDelay$value = this.retryDelay$value;
            if (!this.retryDelay$set) {
                retryDelay$value = TrackingConfiguration.$default$retryDelay();
            }
            boolean ignoreMessageTarget$value = this.ignoreMessageTarget$value;
            if (!this.ignoreMessageTarget$set) {
                ignoreMessageTarget$value = TrackingConfiguration.$default$ignoreMessageTarget();
            }
            TrackingStrategy readStrategy$value = this.readStrategy$value;
            if (!this.readStrategy$set) {
                readStrategy$value = TrackingConfiguration.$default$readStrategy();
            }
            Supplier trackerIdFactory$value = this.trackerIdFactory$value;
            if (!this.trackerIdFactory$set) {
                trackerIdFactory$value = TrackingConfiguration.$default$trackerIdFactory();
            }
            return new TrackingConfiguration(threads$value, typeFilter$value, maxFetchBatchSize$value, maxConsumerBatchSize$value, maxWaitDuration$value, retryDelay$value, batchInterceptors, ignoreMessageTarget$value, readStrategy$value, trackerIdFactory$value);
        }

        public String toString() {
            return "TrackingConfiguration.Builder(threads$value=" + this.threads$value + ", typeFilter$value=" + this.typeFilter$value + ", maxFetchBatchSize$value=" + this.maxFetchBatchSize$value + ", maxConsumerBatchSize$value=" + this.maxConsumerBatchSize$value + ", maxWaitDuration$value=" + this.maxWaitDuration$value + ", retryDelay$value=" + this.retryDelay$value + ", batchInterceptors=" + this.batchInterceptors + ", ignoreMessageTarget$value=" + this.ignoreMessageTarget$value + ", readStrategy$value=" + this.readStrategy$value + ", trackerIdFactory$value=" + this.trackerIdFactory$value + ")";
        }
    }
}

